/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.rest.util;

import java.io.IOException;
import org.apache.activemq.artemis.tests.integration.rest.util.ResponseUtil;
import org.apache.activemq.artemis.tests.integration.rest.util.RestAMQConnection;
import org.apache.activemq.artemis.tests.integration.rest.util.RestMessageContext;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class QueueRestMessageContext
extends RestMessageContext {
    public static final String PREFIX_QUEUE = "/queues/";

    public QueueRestMessageContext(RestAMQConnection restAMQConnection, String queue) throws IOException {
        super(restAMQConnection, queue);
    }

    @Override
    protected String getDestLink() {
        return PREFIX_QUEUE + this.destination;
    }

    @Override
    protected String getPullConsumerUri() {
        return this.getDestLink() + "/pull-consumers";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initPullConsumers() throws IOException {
        String pullUri = this.getPullConsumerUri();
        CloseableHttpResponse response = null;
        response = !this.autoAck ? this.connection.post(pullUri, "application/x-www-form-urlencoded", "autoAck=false") : this.connection.post(pullUri);
        try {
            int code = ResponseUtil.getHttpCode(response);
            if (code == 201) {
                Header header = response.getFirstHeader("Location");
                this.contextMap.put("pull-consumers-location", header.getValue());
                header = response.getFirstHeader("msg-consume-next");
                this.contextMap.put("msg-consume-next", header.getValue());
                header = response.getFirstHeader("msg-acknowledge-next");
                if (header != null) {
                    this.contextMap.put("msg-acknowledge-next", header.getValue());
                }
            }
        }
        finally {
            response.close();
        }
    }

    @Override
    protected String getPushLink(String pushTarget) {
        return PREFIX_QUEUE + pushTarget;
    }
}

