/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class FileLockTimeoutTest
extends ActiveMQTestBase {
    @BeforeClass
    public static void prepareLogger() {
        AssertionLoggerHandler.startCapture();
    }

    @AfterClass
    public static void clearLogger() {
        AssertionLoggerHandler.stopCapture();
    }

    protected void doTest(boolean useAIO) throws Exception {
        if (useAIO) {
            Assert.assertTrue((String)String.format("libAIO is not loaded on %s %s %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")), (boolean)LibaioContext.isLoaded());
        }
        Configuration config = super.createDefaultInVMConfig().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).clearAcceptorConfigurations();
        ActiveMQServer server1 = this.createServer(true, config);
        if (useAIO) {
            server1.getConfiguration().setJournalType(JournalType.ASYNCIO);
        } else {
            server1.getConfiguration().setJournalType(JournalType.NIO);
        }
        server1.start();
        server1.waitForActivation(10L, TimeUnit.SECONDS);
        final ActiveMQServer server2 = this.createServer(true, config);
        if (useAIO) {
            server2.getConfiguration().setJournalType(JournalType.ASYNCIO);
        } else {
            server2.getConfiguration().setJournalType(JournalType.NIO);
        }
        server2.getConfiguration().setJournalLockAcquisitionTimeout(5000L);
        ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    server2.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Future<?> f = service.submit(r);
        try {
            f.get(15L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.instanceLog.warn((Object)"aborting test because server is taking too long to start");
        }
        service.shutdown();
        FileLockTimeoutTest.assertTrue((String)"Expected to find AMQ224000", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224000"}));
        FileLockTimeoutTest.assertTrue((String)"Expected to find \"timed out waiting for lock\"", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"timed out waiting for lock"}));
    }
}

