/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class ResourceLimitTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private TransportConfiguration liveTC;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ResourceLimitSettings resourceLimitSettings = new ResourceLimitSettings();
        resourceLimitSettings.setMatch(SimpleString.toSimpleString((String)"myUser"));
        resourceLimitSettings.setMaxConnections(1);
        resourceLimitSettings.setMaxQueues(1);
        ConfigurationImpl configuration = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY)).addResourceLimitSettings(resourceLimitSettings).setSecurityEnabled(true);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("myUser", "password");
        securityManager.getConfiguration().addRole("myUser", "arole");
        Role role = new Role("arole", false, false, false, false, true, true, false, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("#", roles);
    }

    @Test
    public void testSessionLimitForUser() throws Exception {
        ClientSession extraClientSession;
        ClientSessionFactory extraClientSessionFactory;
        ServerLocator locator = this.addServerLocator(this.createNonHALocator(false));
        ClientSessionFactory clientSessionFactory = locator.createSessionFactory();
        ClientSession clientSession = clientSessionFactory.createSession("myUser", "password", false, true, true, false, 0);
        try {
            extraClientSessionFactory = locator.createSessionFactory();
            extraClientSession = extraClientSessionFactory.createSession("myUser", "password", false, true, true, false, 0);
            ResourceLimitTest.fail((String)"creating a session factory here should fail");
        }
        catch (Exception e) {
            ResourceLimitTest.assertTrue((boolean)(e instanceof ActiveMQSessionCreationException));
        }
        clientSession.close();
        clientSession = clientSessionFactory.createSession("myUser", "password", false, true, true, false, 0);
        try {
            extraClientSessionFactory = locator.createSessionFactory();
            extraClientSession = extraClientSessionFactory.createSession("myUser", "password", false, true, true, false, 0);
            ResourceLimitTest.fail((String)"creating a session factory here should fail");
        }
        catch (Exception e) {
            ResourceLimitTest.assertTrue((boolean)(e instanceof ActiveMQSessionCreationException));
        }
    }

    @Test
    public void testQueueLimitForUser() throws Exception {
        ServerLocator locator = this.addServerLocator(this.createNonHALocator(false));
        ClientSessionFactory clientSessionFactory = locator.createSessionFactory();
        ClientSession clientSession = clientSessionFactory.createSession("myUser", "password", false, true, true, false, 0);
        clientSession.createQueue(new QueueConfiguration("queue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        try {
            clientSession.createQueue(new QueueConfiguration("anotherQueue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        catch (Exception e) {
            ResourceLimitTest.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
        clientSession.deleteQueue("queue");
        clientSession.createQueue(new QueueConfiguration("queue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        try {
            clientSession.createQueue(new QueueConfiguration("anotherQueue").setAddress("address").setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        catch (Exception e) {
            ResourceLimitTest.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
        try {
            clientSession.createSharedQueue(new QueueConfiguration("anotherQueue").setAddress("address").setDurable(Boolean.valueOf(false)));
        }
        catch (Exception e) {
            ResourceLimitTest.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
    }
}

