/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl.fakes;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.impl.QueueFactoryImpl;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;

public final class FakeQueueFactory
implements QueueFactory {
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
    private PostOffice postOffice;

    public Queue createQueueWith(QueueConfig config) {
        return new QueueImpl(config.id(), config.address(), config.name(), config.filter(), config.getPagingStore(), config.pageSubscription(), config.user(), config.isDurable(), config.isTemporary(), config.isAutoCreated(), this.scheduledExecutor, this.postOffice, null, null, ArtemisExecutor.delegate((Executor)this.executor), null, (QueueFactory)this);
    }

    public Queue createQueueWith(QueueConfiguration config, PagingManager pagingManager) throws Exception {
        PageSubscription pageSubscription = QueueFactoryImpl.getPageSubscription((QueueConfiguration)config, (PagingManager)pagingManager);
        return new QueueImpl(config, pageSubscription != null ? pageSubscription.getPagingStore() : null, pageSubscription, this.scheduledExecutor, this.postOffice, null, null, ArtemisExecutor.delegate((Executor)this.executor), null, (QueueFactory)this);
    }

    @Deprecated
    public Queue createQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter, PageSubscription subscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated) {
        return new QueueImpl(persistenceID, address, name, filter, subscription != null ? subscription.getPagingStore() : null, subscription, user, durable, temporary, autoCreated, this.scheduledExecutor, this.postOffice, null, null, ArtemisExecutor.delegate((Executor)this.executor), null, (QueueFactory)this);
    }

    public void setPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    public void stop() throws Exception {
        this.scheduledExecutor.shutdown();
        this.executor.shutdown();
    }
}

