/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionManager;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class JMSTestBase
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    protected JMSServerManagerImpl jmsServer;
    protected MBeanServer mbeanServer;
    protected ConnectionFactory cf;
    protected ConnectionFactory nettyCf;
    protected Connection conn;
    private final Set<JMSContext> contextSet = new HashSet<JMSContext>();
    private final Random random = new Random();
    protected InVMNamingContext namingContext;
    private final Set<Connection> connectionsSet = new HashSet<Connection>();

    protected boolean useSecurity() {
        return false;
    }

    protected boolean useJMX() {
        return true;
    }

    protected boolean usePersistence() {
        return false;
    }

    protected final JMSContext addContext(JMSContext context0) {
        this.contextSet.add(context0);
        return context0;
    }

    protected final JMSContext createContext() {
        return this.addContext(this.cf.createContext());
    }

    protected final JMSContext createContext(int sessionMode) {
        return this.addContext(this.cf.createContext(null, null, sessionMode));
    }

    protected Queue createQueue(String queueName) throws Exception {
        return this.createQueue(false, queueName);
    }

    protected Topic createTopic(String topicName) throws Exception {
        return this.createTopic(false, topicName);
    }

    protected long getMessageCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getMessageCount();
    }

    protected Queue createQueue(boolean storeConfig, String queueName) throws Exception {
        this.jmsServer.createQueue(storeConfig, queueName, null, true, new String[]{"/jms/" + queueName});
        return (Queue)this.namingContext.lookup("/jms/" + queueName);
    }

    protected Topic createTopic(boolean storeConfig, String topicName) throws Exception {
        this.jmsServer.createTopic(storeConfig, topicName, new String[]{"/jms/" + topicName});
        return (Topic)this.namingContext.lookup("/jms/" + topicName);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
        Configuration config = this.createDefaultConfig(true).setSecurityEnabled(this.useSecurity()).addConnectorConfiguration("invm", new TransportConfiguration(INVM_CONNECTOR_FACTORY)).setTransactionTimeoutScanPeriod(100L);
        config.getConnectorConfigurations().put("netty", new TransportConfiguration(NETTY_CONNECTOR_FACTORY));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)this.mbeanServer, (boolean)this.usePersistence()));
        this.extraServerConfig(this.server);
        this.jmsServer = new JMSServerManagerImpl(this.server);
        this.namingContext = new InVMNamingContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.namingContext));
        this.jmsServer.start();
        this.registerConnectionFactory();
    }

    protected void extraServerConfig(ActiveMQServer server) {
    }

    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        return super.createDefaultConfig(netty).setJMXManagementEnabled(true);
    }

    protected void restartServer() throws Exception {
        this.namingContext = new InVMNamingContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.namingContext));
        this.jmsServer.start();
        this.jmsServer.activated();
        this.registerConnectionFactory();
    }

    protected void killServer() throws Exception {
        this.jmsServer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            for (JMSContext jmsContext : this.contextSet) {
                jmsContext.close();
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.contextSet.clear();
        }
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Connection localConn : this.connectionsSet) {
                localConn.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.connectionsSet.clear();
        }
        this.namingContext.close();
        this.jmsServer.stop();
        this.server = null;
        this.cf = null;
        this.jmsServer = null;
        this.namingContext = null;
        MBeanServerFactory.releaseMBeanServer(this.mbeanServer);
        this.mbeanServer = null;
        ServiceUtils.setTransactionManager(null);
        super.tearDown();
    }

    protected void registerConnectionFactory() throws Exception {
        ArrayList<TransportConfiguration> connectorConfigs = new ArrayList<TransportConfiguration>();
        connectorConfigs.add(new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        ArrayList<TransportConfiguration> connectorConfigs1 = new ArrayList<TransportConfiguration>();
        connectorConfigs1.add(new TransportConfiguration(NETTY_CONNECTOR_FACTORY));
        this.createCF(connectorConfigs, "/cf");
        this.createCF("NettyCF", connectorConfigs1, "/nettyCf");
        this.cf = (ConnectionFactory)this.namingContext.lookup("/cf");
        this.nettyCf = (ConnectionFactory)this.namingContext.lookup("/nettyCf");
    }

    protected void createCF(List<TransportConfiguration> connectorConfigs, String ... jndiBindings) throws Exception {
        this.createCF(this.name.getMethodName(), connectorConfigs, jndiBindings);
    }

    protected void createCF(String cfName, List<TransportConfiguration> connectorConfigs, String ... jndiBindings) throws Exception {
        ArrayList connectorNames = this.registerConnectors(this.server, connectorConfigs);
        ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName(cfName).setConnectorNames((List)connectorNames).setRetryInterval(1000L).setReconnectAttempts(-1);
        this.testCaseCfExtraConfig(configuration);
        this.jmsServer.createConnectionFactory(false, configuration, jndiBindings);
    }

    protected void testCaseCfExtraConfig(ConnectionFactoryConfiguration configuration) {
    }

    protected final void sendMessages(JMSContext context, JMSProducer producer, Queue queue, int total) {
        try {
            for (int j = 0; j < total; ++j) {
                StringBuilder sb = new StringBuilder();
                for (int m = 0; m < 200; ++m) {
                    sb.append(this.random.nextLong());
                }
                TextMessage msg = context.createTextMessage(sb.toString());
                msg.setIntProperty("counter", j);
                producer.send((Destination)queue, (Message)msg);
            }
        }
        catch (JMSException cause) {
            throw new JMSRuntimeException(cause.getMessage(), cause.getErrorCode(), (Throwable)cause);
        }
    }

    protected void useDummyTransactionManager() {
        ServiceUtils.setTransactionManager((TransactionManager)new DummyTransactionManager());
    }

    protected final void receiveMessages(JMSConsumer consumer, int start, int msgCount, boolean ack) {
        try {
            for (int i = start; i < msgCount; ++i) {
                Message message = consumer.receive(100L);
                Assert.assertNotNull((String)("Expecting a message " + i), (Object)message);
                int actual = message.getIntProperty("counter");
                Assert.assertEquals((String)("expected=" + i + ". Got: property['counter']=" + actual), (long)i, (long)actual);
                if (!ack) continue;
                message.acknowledge();
            }
        }
        catch (JMSException cause) {
            throw new JMSRuntimeException(cause.getMessage(), cause.getErrorCode(), (Throwable)cause);
        }
    }

    protected final Connection createConnection() throws JMSException {
        Connection c = this.cf.createConnection();
        return this.addConnection(c);
    }

    protected final Connection addConnection(Connection conn) {
        this.connectionsSet.add(conn);
        return conn;
    }
}

