/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.orm.loading.impl.HibernateSessionLoadingInitializer;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IdentifierConsumerDocumentProducer
implements Runnable {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final ProducerConsumerQueue<List<Serializable>> source;
    private final SessionFactory sessionFactory;
    private final CacheMode cacheMode;
    private final IndexedTypeIdentifier type;
    private final MassIndexerProgressMonitor monitor;
    private final IndexedTypeMap<EntityIndexBinding> entityIndexBindings;
    private final String idName;
    private final ErrorHandler errorHandler;
    private final BatchBackend backend;
    private final CountDownLatch producerEndSignal;
    private final Integer transactionTimeout;
    private final String tenantId;
    private final TransactionManager transactionManager;

    public IdentifierConsumerDocumentProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, MassIndexerProgressMonitor monitor, SessionFactory sessionFactory, CountDownLatch producerEndSignal, CacheMode cacheMode, IndexedTypeIdentifier indexedType, ExtendedSearchIntegrator searchFactory, String idName, BatchBackend backend, ErrorHandler errorHandler, Integer transactionTimeout, String tenantId) {
        this.source = fromIdentifierListToEntities;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.type = indexedType;
        this.idName = idName;
        this.backend = backend;
        this.errorHandler = errorHandler;
        this.producerEndSignal = producerEndSignal;
        this.entityIndexBindings = searchFactory.getIndexBindings();
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.transactionManager = ((JtaPlatform)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        log.trace((Object)"created");
    }

    @Override
    public void run() {
        log.trace((Object)"started");
        SessionImplementor session = (SessionImplementor)this.sessionFactory.withOptions().tenantIdentifier(this.tenantId).openSession();
        session.setHibernateFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            this.loadAllFromQueue(session);
        }
        catch (Exception exception) {
            this.errorHandler.handleException(log.massIndexerExceptionWhileTransformingIds(), (Throwable)exception);
        }
        finally {
            this.producerEndSignal.countDown();
            session.close();
        }
        log.trace((Object)"finished");
    }

    private void loadAllFromQueue(SessionImplementor session) throws Exception {
        HibernateSessionLoadingInitializer sessionInitializer = new HibernateSessionLoadingInitializer(session);
        try {
            List<Serializable> idList;
            do {
                if ((idList = this.source.take()) == null) continue;
                log.tracef("received list of ids %s", idList);
                this.loadList(idList, session, sessionInitializer);
            } while (idList != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(List<Serializable> listIds, SessionImplementor session, InstanceInitializer sessionInitializer) throws Exception {
        try {
            this.beginTransaction((Session)session);
            Criteria criteria = new CriteriaImpl(this.type.getName(), (SharedSessionContractImplementor)session).setCacheMode(this.cacheMode).setLockMode(LockMode.NONE).setCacheable(false).setFlushMode(FlushMode.MANUAL).setFetchSize(listIds.size()).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).add(Restrictions.in((String)this.idName, listIds));
            List list = criteria.list();
            this.monitor.entitiesLoaded(list.size());
            this.indexAllQueue((Session)session, list, sessionInitializer);
            session.clear();
        }
        finally {
            this.rollbackTransaction(session);
        }
    }

    private void beginTransaction(Session session) throws Exception {
        if (this.transactionManager != null) {
            if (this.transactionTimeout != null) {
                this.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
            }
            this.transactionManager.begin();
        } else {
            session.beginTransaction();
        }
    }

    private void rollbackTransaction(SessionImplementor session) throws Exception {
        try {
            if (this.transactionManager != null) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            log.errorRollingBackTransaction(e.getMessage(), e);
        }
    }

    private void indexAllQueue(Session session, List<?> entities, InstanceInitializer sessionInitializer) throws InterruptedException {
        ContextualExceptionBridgeHelper contextualBridge = new ContextualExceptionBridgeHelper();
        if (entities == null || entities.isEmpty()) {
            return;
        }
        log.tracef("received a list of objects to index: %s", entities);
        for (Object object : entities) {
            try {
                this.index(object, session, sessionInitializer, (ConversionContext)contextualBridge);
                this.monitor.documentsBuilt(1);
            }
            catch (RuntimeException e) {
                String errorMsg = log.massIndexerUnableToIndexInstance(object.getClass().getName(), object.toString());
                this.errorHandler.handleException(errorMsg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(Object entity, Session session, InstanceInitializer sessionInitializer, ConversionContext conversionContext) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Serializable id = session.getIdentifier(entity);
        Class<Object> clazz = HibernateHelper.getClass(entity);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.entityIndexBindings.get(clazz);
        if (entityIndexBinding == null) {
            return;
        }
        EntityIndexingInterceptor interceptor = entityIndexBinding.getEntityIndexingInterceptor();
        if (interceptor != null) {
            IndexingOverride onAdd = interceptor.onAdd(entity);
            switch (onAdd) {
                case REMOVE: 
                case SKIP: {
                    return;
                }
            }
        }
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        TwoWayFieldBridge idBridge = docBuilder.getIdBridge();
        String idPropertyName = docBuilder.getIdPropertyName();
        if (idPropertyName != null) {
            conversionContext.pushProperty(idPropertyName);
        }
        String idInString = null;
        try {
            idInString = conversionContext.setConvertedTypeId(docBuilder.getTypeIdentifier()).twoWayConversionContext(idBridge).objectToString((Object)id);
        }
        finally {
            if (idPropertyName != null) {
                conversionContext.popProperty();
            }
        }
        AddLuceneWork addWork = docBuilder.createAddWork(this.tenantId, docBuilder.getTypeIdentifier(), entity, id, idInString, sessionInitializer, conversionContext);
        this.backend.enqueueAsyncWork((LuceneWork)addWork);
    }
}

