/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRegistryImpl;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Set;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Metered;

@Metered
@Interceptor
@Priority(value=1010)
public class MeteredInterceptor {
    private final MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.APPLICATION);

    @Inject
    MeteredInterceptor() {
    }

    @AroundConstruct
    Object meteredConstructor(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object meteredMethod(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object meteredTimeout(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object meteredCallable(InvocationContext context, E element) throws Exception {
        Set<MetricID> ids = ((MetricsRegistryImpl)this.registry).getMemberToMetricMappings().getMeters(new CDIMemberInfoAdapter<E>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        ids.stream().map(metricID -> {
            Meter metric = (Meter)this.registry.getMeters().get(metricID);
            if (metric == null) {
                throw SmallRyeMetricsMessages.msg.noMetricFoundInRegistry(MetricType.METERED, (MetricID)metricID);
            }
            return metric;
        }).forEach(Meter::mark);
        return context.proceed();
    }
}

