/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.ConnectionMetaData;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionMetaData;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRACredential;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAMCFProperties;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;

public final class ActiveMQRAManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    static final long serialVersionUID = -1452379518562456741L;
    private ActiveMQResourceAdapter ra;
    private ConnectionManager cm;
    private final ActiveMQRAMCFProperties mcfProperties;
    private ActiveMQConnectionFactory recoveryConnectionFactory;
    private XARecoveryConfig resourceRecovery;
    private boolean inJtaTransaction;

    public ActiveMQRAManagedConnectionFactory() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
        this.ra = null;
        this.cm = null;
        this.mcfProperties = new ActiveMQRAMCFProperties();
    }

    public Object createConnectionFactory() throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.debug("createConnectionFactory()");
        }
        return this.createConnectionFactory(new ActiveMQRAConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createConnectionFactory(" + cxManager + ")");
        }
        this.cm = cxManager;
        ActiveMQRAConnectionFactoryImpl cf = new ActiveMQRAConnectionFactoryImpl(this, this.cm);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("Created connection factory: " + cf + ", using connection manager: " + this.cm);
        }
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createManagedConnection(" + subject + ", " + cxRequestInfo + ")");
        }
        ActiveMQRAConnectionRequestInfo cri = this.getCRI((ActiveMQRAConnectionRequestInfo)cxRequestInfo);
        ActiveMQRACredential credential = ActiveMQRACredential.getCredential(this, subject, cri);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("jms credential: " + credential);
        }
        ActiveMQRAManagedConnection mc = new ActiveMQRAManagedConnection(this, cri, this.ra, credential.getUserName(), credential.getPassword());
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("created new managed connection: " + mc);
        }
        this.registerRecovery();
        return mc;
    }

    private synchronized void registerRecovery() {
        if (this.recoveryConnectionFactory == null) {
            this.recoveryConnectionFactory = this.ra.createRecoveryActiveMQConnectionFactory(this.mcfProperties);
            HashMap<String, String> recoveryConfProps = new HashMap<String, String>();
            recoveryConfProps.put("JNDI_NAME", this.ra.getJndiName());
            this.resourceRecovery = this.ra.getRecoveryManager().register(this.recoveryConnectionFactory, null, null, recoveryConfProps);
        }
    }

    public XARecoveryConfig getResourceRecovery() {
        return this.resourceRecovery;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("matchManagedConnections(" + connectionSet + ", " + subject + ", " + cxRequestInfo + ")");
        }
        ActiveMQRAConnectionRequestInfo cri = this.getCRI((ActiveMQRAConnectionRequestInfo)cxRequestInfo);
        ActiveMQRACredential credential = ActiveMQRACredential.getCredential(this, subject, cri);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("Looking for connection matching credentials: " + credential);
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof ActiveMQRAManagedConnection)) continue;
            ActiveMQRAManagedConnection mc = (ActiveMQRAManagedConnection)obj;
            ActiveMQRAManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.getUserName() != null && (mc.getUserName() == null || !mc.getUserName().equals(credential.getUserName())) || !mcf.equals(this) || !cri.equals(mc.getCRI())) continue;
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("Found matching connection: " + mc);
            }
            return mc;
        }
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("No matching connection was found");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setLogWriter(" + out + ")");
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getLogWriter()");
        }
        return null;
    }

    public ResourceAdapter getResourceAdapter() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getResourceAdapter()");
        }
        return this.ra;
    }

    public boolean isIgnoreJTA() {
        return this.ra.isIgnoreJTA();
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setResourceAdapter(" + ra + ")");
        }
        if (ra == null || !(ra instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (ActiveMQResourceAdapter)ra;
        this.ra.setManagedConnectionFactory(this);
    }

    public boolean equals(Object obj) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("equals(" + obj + ")");
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActiveMQRAManagedConnectionFactory) {
            ActiveMQRAManagedConnectionFactory other = (ActiveMQRAManagedConnectionFactory)obj;
            return this.mcfProperties.equals(other.getProperties()) && this.ra.equals(other.getResourceAdapter());
        }
        return false;
    }

    public int hashCode() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("hashCode()");
        }
        int hash = this.mcfProperties.hashCode();
        return hash += 31 * (this.ra != null ? this.ra.hashCode() : 0);
    }

    public String getSessionDefaultType() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getSessionDefaultType()");
        }
        return this.mcfProperties.getSessionDefaultType();
    }

    public void setSessionDefaultType(String type) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setSessionDefaultType(" + type + ")");
        }
        this.mcfProperties.setSessionDefaultType(type);
    }

    public String getConnectionParameters() {
        return this.mcfProperties.getStrConnectionParameters();
    }

    public void setConnectionParameters(String configuration) {
        this.mcfProperties.setConnectionParameters(configuration);
    }

    public String getConnectorClassName() {
        return this.mcfProperties.getConnectorClassName();
    }

    public void setConnectorClassName(String value) {
        this.mcfProperties.setConnectorClassName(value);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.mcfProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.mcfProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public String getDiscoveryAddress() {
        return this.mcfProperties.getDiscoveryAddress();
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        this.mcfProperties.setDiscoveryAddress(discoveryAddress);
    }

    public Integer getDiscoveryPort() {
        return this.mcfProperties.getDiscoveryPort();
    }

    public void setDiscoveryPort(Integer discoveryPort) {
        this.mcfProperties.setDiscoveryPort(discoveryPort);
    }

    public Long getDiscoveryRefreshTimeout() {
        return this.mcfProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        this.mcfProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        return this.mcfProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        this.mcfProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public String getClientID() {
        return this.mcfProperties.getClientID();
    }

    public void setClientID(String clientID) {
        this.mcfProperties.setClientID(clientID);
    }

    public Integer getDupsOKBatchSize() {
        return this.mcfProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        this.mcfProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        return this.mcfProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        this.mcfProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Long getClientFailureCheckPeriod() {
        return this.mcfProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        this.mcfProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        return this.mcfProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        this.mcfProperties.setConnectionTTL(connectionTTL);
    }

    public Long getCallTimeout() {
        return this.mcfProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        this.mcfProperties.setCallTimeout(callTimeout);
    }

    public Integer getConsumerWindowSize() {
        return this.mcfProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        this.mcfProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        return this.mcfProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        this.mcfProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getConfirmationWindowSize() {
        return this.mcfProperties.getConfirmationWindowSize();
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        this.mcfProperties.setConfirmationWindowSize(confirmationWindowSize);
    }

    public Integer getProducerMaxRate() {
        return this.mcfProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        this.mcfProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getMinLargeMessageSize() {
        return this.mcfProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        this.mcfProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        return this.mcfProperties.isBlockOnAcknowledge();
    }

    public Boolean isBlockOnAcknowledge() {
        return this.mcfProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        this.mcfProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonDurableSend() {
        return this.mcfProperties.isBlockOnNonDurableSend();
    }

    public Boolean isBlockOnNonDurableSend() {
        return this.mcfProperties.isBlockOnNonDurableSend();
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        this.mcfProperties.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public Boolean getBlockOnDurableSend() {
        return this.mcfProperties.isBlockOnDurableSend();
    }

    public Boolean isBlockOnDurableSend() {
        return this.mcfProperties.isBlockOnDurableSend();
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        this.mcfProperties.setBlockOnDurableSend(blockOnDurableSend);
    }

    public Boolean getAutoGroup() {
        return this.mcfProperties.isAutoGroup();
    }

    public Boolean isAutoGroup() {
        return this.mcfProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        this.mcfProperties.setAutoGroup(autoGroup);
    }

    public Boolean getPreAcknowledge() {
        return this.mcfProperties.isPreAcknowledge();
    }

    public Boolean isPreAcknowledge() {
        return this.mcfProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        this.mcfProperties.setPreAcknowledge(preAcknowledge);
    }

    public Long getRetryInterval() {
        return this.mcfProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        this.mcfProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        return this.mcfProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        this.mcfProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Integer getReconnectAttempts() {
        return this.mcfProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        this.mcfProperties.setReconnectAttempts(reconnectAttempts);
    }

    public Boolean getUseGlobalPools() {
        return this.mcfProperties.isUseGlobalPools();
    }

    public Boolean isUseGlobalPools() {
        return this.mcfProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        this.mcfProperties.setUseGlobalPools(useGlobalPools);
    }

    public Boolean getCacheDestinations() {
        return this.mcfProperties.isCacheDestinations();
    }

    public Boolean isCacheDestinations() {
        return this.mcfProperties.isCacheDestinations();
    }

    public void setCacheDestinations(Boolean cacheDestinations) {
        this.mcfProperties.setCacheDestinations(cacheDestinations);
    }

    public Boolean getEnable1xPrefixes() {
        return this.mcfProperties.isEnable1xPrefixes();
    }

    public Boolean isEnable1xPrefixes() {
        return this.mcfProperties.isEnable1xPrefixes();
    }

    public void setEnable1xPrefixes(Boolean enable1xPrefixes) {
        this.mcfProperties.setEnable1xPrefixes(enable1xPrefixes);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.mcfProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        this.mcfProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.mcfProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        this.mcfProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean getHA() {
        return this.mcfProperties.isHA();
    }

    public Boolean isHA() {
        return this.mcfProperties.isHA();
    }

    public void setAllowLocalTransactions(Boolean allowLocalTransactions) {
        this.mcfProperties.setAllowLocalTransactions(allowLocalTransactions);
    }

    public Boolean getAllowLocalTransactions() {
        return this.mcfProperties.isAllowLocalTransactions();
    }

    public Boolean isAllowLocalTransactions() {
        return this.mcfProperties.isAllowLocalTransactions();
    }

    public Boolean getInJtaTransaction() {
        return this.mcfProperties.isInJtaTransaction();
    }

    public Boolean isInJtaTransaction() {
        return this.mcfProperties.isInJtaTransaction();
    }

    public void setInJtaTransaction(Boolean inJtaTransaction) {
        this.mcfProperties.setInJtaTransaction(inJtaTransaction);
    }

    public void setHA(Boolean ha) {
        this.mcfProperties.setHA(ha);
    }

    public Integer getUseTryLock() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getUseTryLock()");
        }
        return this.mcfProperties.getUseTryLock();
    }

    public void setUseTryLock(Integer useTryLock) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setUseTryLock(" + useTryLock + ")");
        }
        this.mcfProperties.setUseTryLock(useTryLock);
    }

    public ConnectionMetaData getMetaData() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getMetadata()");
        }
        return new ActiveMQRAConnectionMetaData();
    }

    protected ActiveMQRAMCFProperties getProperties() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getProperties()");
        }
        return this.mcfProperties;
    }

    private ActiveMQRAConnectionRequestInfo getCRI(ActiveMQRAConnectionRequestInfo info) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getCRI(" + info + ")");
        }
        if (info == null) {
            return new ActiveMQRAConnectionRequestInfo(this.ra.getProperties(), this.mcfProperties.getType());
        }
        info.setDefaults(this.ra.getProperties());
        return info;
    }

    public void stop() {
        if (this.resourceRecovery != null) {
            this.ra.getRecoveryManager().unRegister(this.resourceRecovery);
        }
        if (this.recoveryConnectionFactory != null) {
            this.recoveryConnectionFactory.close();
            this.recoveryConnectionFactory = null;
        }
    }
}

