/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapter;
import java.io.Serializable;
import java.util.Hashtable;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationValidationUtils;
import org.jboss.logging.Logger;

public class ActiveMQActivationSpec
extends ConnectionFactoryProperties
implements ActivationSpec,
Serializable {
    private static final Logger logger = Logger.getLogger(ActiveMQActivationSpec.class);
    private static final long serialVersionUID = -7997041053897964654L;
    private static final int DEFAULT_MAX_SESSION = 15;
    public String strConnectorClassName;
    public String strConnectionParameters;
    protected Boolean allowLocalTransactions;
    private ActiveMQResourceAdapter ra;
    private String connectionFactoryLookup;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private Integer acknowledgeMode;
    private Boolean subscriptionDurability;
    private String subscriptionName;
    private Boolean shareSubscriptions = false;
    private String user;
    private String password;
    private Integer maxSession;
    private Integer transactionTimeout;
    private Boolean useJNDI = true;
    private String jndiParams = null;
    private Hashtable<String, String> parsedJndiParams;
    private Boolean localTx;
    private Integer setupAttempts;
    private Long setupInterval;
    private Boolean rebalanceConnections = false;
    private String topicPrefix;
    private String queuePrefix;

    public ActiveMQActivationSpec() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"constructor()");
        }
        this.ra = new ActiveMQResourceAdapter();
        this.destination = null;
        this.destinationType = null;
        this.messageSelector = null;
        this.acknowledgeMode = 1;
        this.subscriptionDurability = false;
        this.subscriptionName = null;
        this.user = null;
        this.password = null;
        this.maxSession = 15;
        this.transactionTimeout = 0;
    }

    public ResourceAdapter getResourceAdapter() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getResourceAdapter()");
        }
        return this.ra;
    }

    public Boolean isUseJNDI() {
        if (this.useJNDI == null) {
            return this.ra.isUseJNDI();
        }
        return this.useJNDI;
    }

    public void setUseJNDI(Boolean value) {
        this.useJNDI = value;
    }

    public String getJndiParams() {
        if (this.jndiParams == null) {
            return this.ra.getJndiParams();
        }
        return this.jndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.jndiParams = jndiParams;
        this.parsedJndiParams = ActiveMQRaUtils.parseHashtableConfig(jndiParams);
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        if (this.parsedJndiParams == null) {
            return this.ra.getParsedJndiParams();
        }
        return this.parsedJndiParams;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setResourceAdapter(" + ra + ")"));
        }
        if (ra == null || !(ra instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (ActiveMQResourceAdapter)ra;
    }

    public String getConnectionFactoryLookup() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getConnectionFactoryLookup() ->" + this.connectionFactoryLookup));
        }
        return this.connectionFactoryLookup;
    }

    public void setConnectionFactoryLookup(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setConnectionFactoryLookup(" + value + ")"));
        }
        this.connectionFactoryLookup = value;
    }

    public String getDestination() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDestination()");
        }
        return this.destination;
    }

    public void setDestination(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDestination(" + value + ")"));
        }
        this.destination = value;
    }

    public String getDestinationLookup() {
        return this.getDestination();
    }

    public void setDestinationLookup(String value) {
        this.setDestination(value);
        this.setUseJNDI(true);
    }

    public String getDestinationType() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDestinationType()");
        }
        return this.destinationType;
    }

    public void setDestinationType(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDestinationType(" + value + ")"));
        }
        this.destinationType = value;
    }

    public String getMessageSelector() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getMessageSelector()");
        }
        return this.messageSelector;
    }

    public void setMessageSelector(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setMessageSelector(" + value + ")"));
        }
        this.messageSelector = value;
    }

    public String getAcknowledgeMode() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getAcknowledgeMode()");
        }
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setQueuePrefix(String prefix) {
        this.queuePrefix = prefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setTopicPrefix(String prefix) {
        this.topicPrefix = prefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setAcknowledgeMode(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setAcknowledgeMode(" + value + ")"));
        }
        try {
            this.acknowledgeMode = ActiveMQActivationValidationUtils.validateAcknowledgeMode(value);
        }
        catch (IllegalArgumentException e) {
            ActiveMQRALogger.LOGGER.invalidAcknowledgementMode(value);
            throw e;
        }
    }

    public Integer getAcknowledgeModeInt() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public String getSubscriptionDurability() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getSubscriptionDurability()");
        }
        if (this.subscriptionDurability.booleanValue()) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setSubscriptionDurability(" + value + ")"));
        }
        this.subscriptionDurability = "Durable".equals(value);
    }

    public Boolean isSubscriptionDurable() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"isSubscriptionDurable()");
        }
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getSubscriptionName()");
        }
        return this.subscriptionName;
    }

    public void setSubscriptionName(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setSubscriptionName(" + value + ")"));
        }
        this.subscriptionName = value;
    }

    public Boolean isShareSubscriptions() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("isShareSubscriptions() = " + this.shareSubscriptions));
        }
        return this.shareSubscriptions;
    }

    public void setShareSubscriptions(Boolean shareSubscriptions) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setShareSubscriptions(" + shareSubscriptions + ")"));
        }
        this.shareSubscriptions = shareSubscriptions;
    }

    public String getUser() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getUser()");
        }
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUser(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setUser(" + value + ")"));
        }
        this.user = value;
    }

    public String getPassword() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getPassword()");
        }
        if (this.password == null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public String getOwnPassword() {
        return this.password;
    }

    public void setPassword(String value) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"setPassword(****)");
        }
        this.password = value;
    }

    public Integer getMaxSession() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getMaxSession()");
        }
        if (this.maxSession == null) {
            return 15;
        }
        return this.maxSession;
    }

    public void setMaxSession(Integer value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setMaxSession(" + value + ")"));
        }
        if (value < 1) {
            this.maxSession = 1;
            ActiveMQRALogger.LOGGER.invalidNumberOfMaxSession(value, this.maxSession);
        } else {
            this.maxSession = value;
        }
    }

    public Integer getTransactionTimeout() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getTransactionTimeout()");
        }
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(Integer value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setTransactionTimeout(" + value + ")"));
        }
        this.transactionTimeout = value;
    }

    public Boolean isUseLocalTx() {
        if (this.localTx == null) {
            return this.ra.getUseLocalTx();
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        this.localTx = localTx;
    }

    public Boolean isRebalanceConnections() {
        return this.rebalanceConnections;
    }

    public void setRebalanceConnections(Boolean rebalanceConnections) {
        this.rebalanceConnections = rebalanceConnections;
    }

    public Integer getSetupAttempts() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getSetupAttempts()");
        }
        if (this.setupAttempts == null) {
            return this.ra.getSetupAttempts();
        }
        return this.setupAttempts;
    }

    public void setSetupAttempts(Integer setupAttempts) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setSetupAttempts(" + setupAttempts + ")"));
        }
        this.setupAttempts = setupAttempts;
    }

    public Long getSetupInterval() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getSetupInterval()");
        }
        if (this.setupInterval == null) {
            return this.ra.getSetupInterval();
        }
        return this.setupInterval;
    }

    public void setSetupInterval(Long setupInterval) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setSetupInterval(" + setupInterval + ")"));
        }
        this.setupInterval = setupInterval;
    }

    public void setClientId(String clientId) {
        this.setClientID(clientId);
    }

    public void validate() throws InvalidPropertyException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"validate()");
        }
        ActiveMQActivationValidationUtils.validate(this.destination, this.destinationType, this.isSubscriptionDurable(), this.subscriptionName);
    }

    public String getConnectorClassName() {
        return this.strConnectorClassName;
    }

    public void setConnectorClassName(String connectorClassName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setConnectorClassName(" + connectorClassName + ")"));
        }
        this.strConnectorClassName = connectorClassName;
        this.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(configuration));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ActiveMQActivationSpec.class.getName()).append('(');
        buffer.append("ra=").append(this.ra);
        if (this.connectionFactoryLookup != null) {
            buffer.append(" connectionFactoryLookup=").append(this.connectionFactoryLookup);
        }
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" ack=").append(this.getAcknowledgeMode());
        buffer.append(" durable=").append(this.subscriptionDurability);
        buffer.append(" clientID=").append(this.getClientID());
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" user=").append(this.user);
        if (this.password != null) {
            buffer.append(" password=").append("****");
        }
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(')');
        return buffer.toString();
    }

    public void setUseDLQ(Boolean b) {
    }

    public void setDLQJNDIName(String name) {
    }

    public void setDLQHandler(String handler) {
    }

    public void setDLQMaxResent(Integer maxResent) {
    }

    public void setProviderAdapterJNDI(String jndi) {
    }

    public void setKeepAlive(Boolean keepAlive) {
    }

    public void setKeepAliveMillis(Long keepAliveMillis) {
    }

    public void setReconnectInterval(Long interval) {
    }

    public void setMinSession(Integer value) {
    }

    public void setMaxMessages(Integer value) {
    }

    public Boolean isAllowLocalTransactions() {
        return this.allowLocalTransactions;
    }

    public void setAllowLocalTransactions(Boolean allowLocalTransactions) {
        this.allowLocalTransactions = allowLocalTransactions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActiveMQActivationSpec that = (ActiveMQActivationSpec)o;
        if (this.acknowledgeMode != null ? !this.acknowledgeMode.equals(that.acknowledgeMode) : that.acknowledgeMode != null) {
            return false;
        }
        if (this.subscriptionDurability != that.subscriptionDurability) {
            return false;
        }
        if (this.shareSubscriptions != that.shareSubscriptions) {
            return false;
        }
        if (this.strConnectorClassName != null ? !this.strConnectorClassName.equals(that.strConnectorClassName) : that.strConnectorClassName != null) {
            return false;
        }
        if (this.strConnectionParameters != null ? !this.strConnectionParameters.equals(that.strConnectionParameters) : that.strConnectionParameters != null) {
            return false;
        }
        if (this.ra != null ? !this.ra.equals(that.ra) : that.ra != null) {
            return false;
        }
        if (this.connectionFactoryLookup != null ? !this.connectionFactoryLookup.equals(that.connectionFactoryLookup) : that.connectionFactoryLookup != null) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.destinationType != null ? !this.destinationType.equals(that.destinationType) : that.destinationType != null) {
            return false;
        }
        if (this.messageSelector != null ? !this.messageSelector.equals(that.messageSelector) : that.messageSelector != null) {
            return false;
        }
        if (this.subscriptionName != null ? !this.subscriptionName.equals(that.subscriptionName) : that.subscriptionName != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.maxSession != null ? !this.maxSession.equals(that.maxSession) : that.maxSession != null) {
            return false;
        }
        if (this.transactionTimeout != null ? !this.transactionTimeout.equals(that.transactionTimeout) : that.transactionTimeout != null) {
            return false;
        }
        if (this.useJNDI != null ? !this.useJNDI.equals(that.useJNDI) : that.useJNDI != null) {
            return false;
        }
        if (this.jndiParams != null ? !this.jndiParams.equals(that.jndiParams) : that.jndiParams != null) {
            return false;
        }
        if (this.parsedJndiParams != null ? !this.parsedJndiParams.equals(that.parsedJndiParams) : that.parsedJndiParams != null) {
            return false;
        }
        if (this.localTx != null ? !this.localTx.equals(that.localTx) : that.localTx != null) {
            return false;
        }
        if (this.rebalanceConnections != null ? !this.rebalanceConnections.equals(that.rebalanceConnections) : that.rebalanceConnections != null) {
            return false;
        }
        if (this.setupAttempts != null ? !this.setupAttempts.equals(that.setupAttempts) : that.setupAttempts != null) {
            return false;
        }
        if (this.queuePrefix != null ? !this.queuePrefix.equals(that.queuePrefix) : that.queuePrefix != null) {
            return false;
        }
        if (this.topicPrefix != null ? !this.topicPrefix.equals(that.topicPrefix) : that.topicPrefix != null) {
            return false;
        }
        return !(this.setupInterval == null ? that.setupInterval != null : !this.setupInterval.equals(that.setupInterval));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.strConnectorClassName != null ? this.strConnectorClassName.hashCode() : 0);
        result = 31 * result + (this.strConnectionParameters != null ? this.strConnectionParameters.hashCode() : 0);
        result = 31 * result + (this.ra != null ? this.ra.hashCode() : 0);
        result = 31 * result + (this.connectionFactoryLookup != null ? this.connectionFactoryLookup.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.destinationType != null ? this.destinationType.hashCode() : 0);
        result = 31 * result + (this.messageSelector != null ? this.messageSelector.hashCode() : 0);
        result = 31 * result + this.acknowledgeMode;
        result = 31 * result + (this.subscriptionDurability != false ? 1 : 0);
        result = 31 * result + (this.subscriptionName != null ? this.subscriptionName.hashCode() : 0);
        result = 31 * result + (this.shareSubscriptions != null && this.shareSubscriptions != false ? 1 : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.maxSession != null ? this.maxSession.hashCode() : 0);
        result = 31 * result + (this.transactionTimeout != null ? this.transactionTimeout.hashCode() : 0);
        result = 31 * result + (this.useJNDI != null ? this.useJNDI.hashCode() : 0);
        result = 31 * result + (this.jndiParams != null ? this.jndiParams.hashCode() : 0);
        result = 31 * result + (this.parsedJndiParams != null ? this.parsedJndiParams.hashCode() : 0);
        result = 31 * result + (this.localTx != null ? this.localTx.hashCode() : 0);
        result = 31 * result + (this.rebalanceConnections != null ? this.rebalanceConnections.hashCode() : 0);
        result = 31 * result + (this.setupAttempts != null ? this.setupAttempts.hashCode() : 0);
        result = 31 * result + (this.setupInterval != null ? this.setupInterval.hashCode() : 0);
        result = 31 * result + (this.queuePrefix != null ? this.queuePrefix.hashCode() : 0);
        result = 31 * result + (this.topicPrefix != null ? this.topicPrefix.hashCode() : 0);
        return result;
    }
}

