/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.util.ArrayList;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;

public class JSFMetadataProcessor
implements DeploymentUnitProcessor {
    public static final String JAVAX_FACES_WEBAPP_FACES_SERVLET = "jakarta.faces.webapp.FacesServlet";
    private static final String DISALLOW_DOCTYPE_DECL = "com.sun.faces.disallowDoctypeDecl";
    private static final String LAZY_BEAN_VALIDATION_PARAM = "com.sun.faces.enableLazyBeanValidation";
    private final Boolean disallowDoctypeDecl;

    public JSFMetadataProcessor(Boolean disallowDoctypeDecl) {
        this.disallowDoctypeDecl = disallowDoctypeDecl;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (JsfVersionMarker.isJsfDisabled(deploymentUnit)) {
            return;
        }
        if (metaData == null || metaData.getMergedJBossWebMetaData() == null || metaData.getMergedJBossWebMetaData().getServlets() == null) {
            return;
        }
        JBossServletMetaData jsf = null;
        for (JBossServletMetaData servlet : metaData.getMergedJBossWebMetaData().getServlets()) {
            if (!JAVAX_FACES_WEBAPP_FACES_SERVLET.equals(servlet.getServletClass())) continue;
            jsf = servlet;
        }
        if (jsf != null && jsf.getMultipartConfig() == null) {
            jsf.setMultipartConfig(new MultipartConfigMetaData());
        }
        if (this.disallowDoctypeDecl != null) {
            JSFMetadataProcessor.setContextParameterIfAbsent(metaData.getMergedJBossWebMetaData(), DISALLOW_DOCTYPE_DECL, this.disallowDoctypeDecl.toString());
        }
        if (metaData.getMergedJBossWebMetaData().getDistributable() != null) {
            String disabled = Boolean.toString(false);
            if (!JSFMetadataProcessor.setContextParameterIfAbsent(metaData.getMergedJBossWebMetaData(), LAZY_BEAN_VALIDATION_PARAM, disabled).equals(disabled)) {
                JSFLogger.ROOT_LOGGER.lazyBeanValidationEnabled();
            }
        }
    }

    private static String setContextParameterIfAbsent(JBossWebMetaData webMetaData, String name, String value) {
        ArrayList<ParamValueMetaData> contextParams = webMetaData.getContextParams();
        if (contextParams == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
            webMetaData.setContextParams(contextParams);
        }
        for (ParamValueMetaData param : contextParams) {
            if (!name.equals(param.getParamName()) || param.getParamValue() == null) continue;
            return param.getParamValue();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        contextParams.add(param);
        return value;
    }
}

