/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing;

import io.opentracing.Tracer;
import io.smallrye.opentracing.OpenTracingAsyncInterceptorFactory;
import io.smallrye.opentracing.SmallRyeClientTracingFeature;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class SmallRyeRestClientListener
implements RestClientListener {
    public void onNewClient(Class<?> clientInterface, RestClientBuilder restClientBuilder) {
        Traced traced = clientInterface.getAnnotation(Traced.class);
        if (traced != null && !traced.value()) {
            return;
        }
        Tracer tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        restClientBuilder.register((Object)new SmallRyeClientTracingFeature(tracer));
        restClientBuilder.register((Object)new OpenTracingAsyncInterceptorFactory(tracer));
    }
}

