/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Command;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.UserAction;

@Command(name="list", description="List existing user(s)")
public class ListUser
extends UserAction {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.list();
        return null;
    }

    private void list() throws Exception {
        StringBuilder logMessage = new StringBuilder("--- \"user\"(roles) ---\n");
        int userCount = 0;
        final String[] result = new String[1];
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listUser", (Object[])new Object[]{ListUser.this.userCommandUser});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                result[0] = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                ((ListUser)ListUser.this).context.err.println("Failed to list user " + ListUser.this.userCommandUser + ". Reason: " + errMsg);
            }
        });
        JsonArray array = JsonUtil.readJsonArray((String)result[0]);
        for (JsonObject object : array.getValuesAs(JsonObject.class)) {
            logMessage.append("\"").append(object.getString("username")).append("\"").append("(");
            JsonArray roles = object.getJsonArray("roles");
            for (int i = 0; i < roles.size(); ++i) {
                logMessage.append(roles.getString(i));
                if (i + 1 >= roles.size()) continue;
                logMessage.append(",");
            }
            logMessage.append(")\n");
            ++userCount;
        }
        logMessage.append("\n Total: ").append(userCount);
        this.context.out.println(logMessage);
    }
}

