/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AccessLogDefinition;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.XnioWorker;

final class AccessLogAdd
extends AbstractAddStepHandler {
    static final AccessLogAdd INSTANCE = new AccessLogAdd();

    private AccessLogAdd() {
        super(AccessLogDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress hostAddress = address.getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String worker = AccessLogDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String pattern = AccessLogDefinition.PATTERN.resolveModelAttribute(context, model).asString();
        String directory = AccessLogDefinition.DIRECTORY.resolveModelAttribute(context, model).asString();
        String filePrefix = AccessLogDefinition.PREFIX.resolveModelAttribute(context, model).asString();
        String fileSuffix = AccessLogDefinition.SUFFIX.resolveModelAttribute(context, model).asString();
        boolean useServerLog = AccessLogDefinition.USE_SERVER_LOG.resolveModelAttribute(context, model).asBoolean();
        boolean rotate = AccessLogDefinition.ROTATE.resolveModelAttribute(context, model).asBoolean();
        boolean extended = AccessLogDefinition.EXTENDED.resolveModelAttribute(context, model).asBoolean();
        ModelNode relativeToNode = AccessLogDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        Predicate predicate = null;
        ModelNode predicateNode = AccessLogDefinition.PREDICATE.resolveModelAttribute(context, model);
        if (predicateNode.isDefined()) {
            predicate = Predicates.parse((String)predicateNode.asString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(AccessLogDefinition.ACCESS_LOG_CAPABILITY);
        Consumer sConsumer = sb.provides(AccessLogDefinition.ACCESS_LOG_CAPABILITY, UndertowService.accessLogServiceName(serverName, hostName), new ServiceName[0]);
        Supplier hSupplier = sb.requiresCapability("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName});
        Supplier wSupplier = sb.requiresCapability("org.wildfly.io.worker", XnioWorker.class, new String[]{worker});
        Supplier pmSupplier = sb.requires(PathManagerService.SERVICE_NAME);
        AccessLogService service = useServerLog ? new AccessLogService(sConsumer, hSupplier, wSupplier, pmSupplier, pattern, extended, predicate) : new AccessLogService(sConsumer, hSupplier, wSupplier, pmSupplier, pattern, directory, relativeTo, filePrefix, fileSuffix, rotate, extended, false, predicate);
        sb.setInstance((Service)service);
        sb.install();
    }
}

