/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.UndertowOptions;
import io.undertow.client.UndertowClient;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.proxy.RouteParsingStrategy;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.io.IOException;
import java.net.InetAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FailoverStrategy;
import org.wildfly.extension.undertow.filters.FilterService;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.RankedAffinityResourceDefinition;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class ModClusterService
extends FilterService {
    private final Supplier<XnioWorker> worker;
    private final Supplier<SocketBinding> managementSocketBinding;
    private final Supplier<SocketBinding> advertiseSocketBinding;
    private final Supplier<SSLContext> sslContext;
    private final long healthCheckInterval;
    private final int maxRequestTime;
    private final long removeBrokenNodes;
    private final int advertiseFrequency;
    private final String advertisePath;
    private final String advertiseProtocol;
    private final String securityKey;
    private final Predicate managementAccessPredicate;
    private final int connectionsPerThread;
    private final int cachedConnections;
    private final int connectionIdleTimeout;
    private final int requestQueueSize;
    private final boolean useAlias;
    private final int maxRetries;
    private final FailoverStrategy failoverStrategy;
    private final RouteParsingStrategy routeParsingStrategy;
    private final String routeDelimiter;
    private ModCluster modCluster;
    private MCMPConfig config;
    private final OptionMap clientOptions;

    ModClusterService(Consumer<FilterService> serviceConsumer, Supplier<XnioWorker> worker, Supplier<SocketBinding> managementSocketBinding, Supplier<SocketBinding> advertiseSocketBinding, Supplier<SSLContext> sslContext, ModelNode model, long healthCheckInterval, int maxRequestTime, long removeBrokenNodes, int advertiseFrequency, String advertisePath, String advertiseProtocol, String securityKey, Predicate managementAccessPredicate, int connectionsPerThread, int cachedConnections, int connectionIdleTimeout, int requestQueueSize, boolean useAlias, int maxRetries, FailoverStrategy failoverStrategy, RouteParsingStrategy routeParsingStrategy, String routeDelimiter, OptionMap clientOptions) {
        super(serviceConsumer, ModClusterDefinition.INSTANCE, model);
        this.worker = worker;
        this.managementSocketBinding = managementSocketBinding;
        this.advertiseSocketBinding = advertiseSocketBinding;
        this.sslContext = sslContext;
        this.healthCheckInterval = healthCheckInterval;
        this.maxRequestTime = maxRequestTime;
        this.removeBrokenNodes = removeBrokenNodes;
        this.advertiseFrequency = advertiseFrequency;
        this.advertisePath = advertisePath;
        this.advertiseProtocol = advertiseProtocol;
        this.securityKey = securityKey;
        this.managementAccessPredicate = managementAccessPredicate;
        this.connectionsPerThread = connectionsPerThread;
        this.cachedConnections = cachedConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.requestQueueSize = requestQueueSize;
        this.useAlias = useAlias;
        this.maxRetries = maxRetries;
        this.failoverStrategy = failoverStrategy;
        this.routeParsingStrategy = routeParsingStrategy;
        this.routeDelimiter = routeDelimiter;
        this.clientOptions = clientOptions;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        SocketBinding advertiseBinding;
        OptionMap.Builder builder;
        ModCluster.Builder modClusterBuilder;
        super.start(context);
        SSLContext sslContext = this.sslContext != null ? this.sslContext.get() : null;
        XnioWorker worker = this.worker.get();
        if (sslContext == null) {
            modClusterBuilder = ModCluster.builder((XnioWorker)worker);
        } else {
            builder = OptionMap.builder();
            builder.set(Options.USE_DIRECT_BUFFERS, true);
            OptionMap combined = builder.getMap();
            UndertowXnioSsl xnioSsl = new UndertowXnioSsl(worker.getXnio(), combined, sslContext);
            modClusterBuilder = ModCluster.builder((XnioWorker)worker, (UndertowClient)UndertowClient.getInstance(), (XnioSsl)xnioSsl);
        }
        modClusterBuilder.setMaxRetries(this.maxRetries).setClientOptions(this.clientOptions).setHealthCheckInterval(this.healthCheckInterval).setMaxRequestTime(this.maxRequestTime).setCacheConnections(this.cachedConnections).setQueueNewRequests(this.requestQueueSize > 0).setRequestQueueSize(this.requestQueueSize).setRemoveBrokenNodes(this.removeBrokenNodes).setTtl((long)this.connectionIdleTimeout).setMaxConnections(this.connectionsPerThread).setUseAlias(this.useAlias).setRouteParsingStrategy(this.routeParsingStrategy).setRankedAffinityDelimiter(this.routeDelimiter);
        if (FailoverStrategy.DETERMINISTIC.equals((Object)this.failoverStrategy)) {
            modClusterBuilder.setDeterministicFailover(true);
        }
        this.modCluster = modClusterBuilder.build();
        builder = MCMPConfig.builder();
        SocketBinding socketBinding = advertiseBinding = this.advertiseSocketBinding != null ? this.advertiseSocketBinding.get() : null;
        if (advertiseBinding != null) {
            InetAddress multicastAddress = advertiseBinding.getMulticastAddress();
            if (multicastAddress == null) {
                throw UndertowLogger.ROOT_LOGGER.advertiseSocketBindingRequiresMulticastAddress();
            }
            if (this.advertiseFrequency > 0) {
                builder.enableAdvertise().setAdvertiseAddress(advertiseBinding.getSocketAddress().getAddress().getHostAddress()).setAdvertiseGroup(multicastAddress.getHostAddress()).setAdvertisePort(advertiseBinding.getMulticastPort()).setAdvertiseFrequency(this.advertiseFrequency).setPath(this.advertisePath).setProtocol(this.advertiseProtocol).setSecurityKey(this.securityKey);
            }
        }
        builder.setManagementHost(this.managementSocketBinding.get().getSocketAddress().getHostString());
        builder.setManagementPort(this.managementSocketBinding.get().getSocketAddress().getPort());
        this.config = builder.build();
        if (advertiseBinding != null && this.advertiseFrequency > 0) {
            try {
                this.modCluster.advertise(this.config);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.modCluster.start();
    }

    @Override
    public synchronized void stop(StopContext context) {
        super.stop(context);
        this.modCluster.stop();
        this.modCluster = null;
        this.config = null;
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, final HttpHandler next) {
        final HttpHandler proxyHandler = this.modCluster.createProxyHandler(next);
        HttpHandler realNext = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                proxyHandler.handleRequest(exchange);
                if (!exchange.isDispatched() && !exchange.isComplete()) {
                    exchange.setStatusCode(200);
                    next.handleRequest(exchange);
                }
            }
        };
        HttpHandler mcmp = this.managementAccessPredicate != null ? Handlers.predicate((Predicate)this.managementAccessPredicate, (HttpHandler)this.config.create(this.modCluster, realNext), (HttpHandler)next) : this.config.create(this.modCluster, realNext);
        UndertowLogger.ROOT_LOGGER.debug("HttpHandler for mod_cluster MCMP created.");
        if (predicate != null) {
            return new PredicateHandler(predicate, mcmp, next);
        }
        return mcmp;
    }

    static void install(String name, CapabilityServiceTarget serviceTarget, ModelNode model, OperationContext operationContext) throws OperationFailedException {
        String securityKey = null;
        ModelNode securityKeyNode = ModClusterDefinition.SECURITY_KEY.resolveModelAttribute(operationContext, model);
        if (securityKeyNode.isDefined()) {
            securityKey = securityKeyNode.asString();
        }
        String managementAccessPredicateString = null;
        ModelNode managementAccessPredicateNode = ModClusterDefinition.MANAGEMENT_ACCESS_PREDICATE.resolveModelAttribute(operationContext, model);
        if (managementAccessPredicateNode.isDefined()) {
            managementAccessPredicateString = managementAccessPredicateNode.asString();
        }
        Predicate managementAccessPredicate = null;
        if (managementAccessPredicateString != null) {
            managementAccessPredicate = PredicateParser.parse((String)managementAccessPredicateString, (ClassLoader)ModClusterService.class.getClassLoader());
        }
        ModelNode sslContext = ModClusterDefinition.SSL_CONTEXT.resolveModelAttribute(operationContext, model);
        ModelNode securityRealm = ModClusterDefinition.SECURITY_REALM.resolveModelAttribute(operationContext, model);
        ModelNode packetSizeNode = ModClusterDefinition.MAX_AJP_PACKET_SIZE.resolveModelAttribute(operationContext, model);
        OptionMap.Builder builder = OptionMap.builder();
        if (packetSizeNode.isDefined()) {
            builder.set(UndertowOptions.MAX_AJP_PACKET_SIZE, packetSizeNode.asInt());
        }
        builder.set(UndertowOptions.ENABLE_HTTP2, ModClusterDefinition.ENABLE_HTTP2.resolveModelAttribute(operationContext, model).asBoolean());
        ModClusterDefinition.HTTP2_ENABLE_PUSH.resolveOption((ExpressionResolver)operationContext, model, builder);
        ModClusterDefinition.HTTP2_HEADER_TABLE_SIZE.resolveOption((ExpressionResolver)operationContext, model, builder);
        ModClusterDefinition.HTTP2_INITIAL_WINDOW_SIZE.resolveOption((ExpressionResolver)operationContext, model, builder);
        ModClusterDefinition.HTTP2_MAX_CONCURRENT_STREAMS.resolveOption((ExpressionResolver)operationContext, model, builder);
        ModClusterDefinition.HTTP2_MAX_FRAME_SIZE.resolveOption((ExpressionResolver)operationContext, model, builder);
        ModClusterDefinition.HTTP2_MAX_HEADER_LIST_SIZE.resolveOption((ExpressionResolver)operationContext, model, builder);
        ModelNode affinityNode = model.get("affinity");
        RouteParsingStrategy routeParsingStrategy = RouteParsingStrategy.SINGLE;
        String routeDelimiter = null;
        if (affinityNode.hasDefined("none")) {
            routeParsingStrategy = RouteParsingStrategy.NONE;
        } else if (affinityNode.hasDefined("ranked")) {
            ModelNode rankedModelNode = affinityNode.get("ranked");
            routeParsingStrategy = RouteParsingStrategy.RANKED;
            routeDelimiter = RankedAffinityResourceDefinition.Attribute.DELIMITER.resolveModelAttribute((ExpressionResolver)operationContext, rankedModelNode).asString();
        }
        String mgmtSocketBindingRef = ModClusterDefinition.MANAGEMENT_SOCKET_BINDING.resolveModelAttribute(operationContext, model).asString();
        ModelNode advertiseSocketBindingRef = ModClusterDefinition.ADVERTISE_SOCKET_BINDING.resolveModelAttribute(operationContext, model);
        String workerRef = ModClusterDefinition.WORKER.resolveModelAttribute(operationContext, model).asString();
        RuntimeCapability<Void> capabilityName = ModClusterDefinition.Capability.MOD_CLUSTER_FILTER_CAPABILITY.getDefinition();
        CapabilityServiceBuilder sb = serviceTarget.addCapability(capabilityName);
        Consumer serviceConsumer = sb.provides(capabilityName, UndertowService.FILTER.append(new String[]{name}), new ServiceName[0]);
        Supplier xwSupplier = sb.requiresCapability("org.wildfly.io.worker", XnioWorker.class, new String[]{workerRef});
        Supplier msbSupplier = sb.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{mgmtSocketBindingRef});
        Supplier asbSupplier = advertiseSocketBindingRef.isDefined() ? sb.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{advertiseSocketBindingRef.asString()}) : null;
        Supplier scSupplier = sslContext.isDefined() ? sb.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{sslContext.asString()}) : null;
        ModClusterService service = new ModClusterService(serviceConsumer, xwSupplier, msbSupplier, asbSupplier, scSupplier, model, ModClusterDefinition.HEALTH_CHECK_INTERVAL.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.MAX_REQUEST_TIME.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.BROKEN_NODE_TIMEOUT.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.ADVERTISE_FREQUENCY.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.ADVERTISE_PATH.resolveModelAttribute(operationContext, model).asString(), ModClusterDefinition.ADVERTISE_PROTOCOL.resolveModelAttribute(operationContext, model).asString(), securityKey, managementAccessPredicate, ModClusterDefinition.CONNECTIONS_PER_THREAD.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.CACHED_CONNECTIONS_PER_THREAD.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.CONNECTION_IDLE_TIMEOUT.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.REQUEST_QUEUE_SIZE.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.USE_ALIAS.resolveModelAttribute(operationContext, model).asBoolean(), ModClusterDefinition.MAX_RETRIES.resolveModelAttribute(operationContext, model).asInt(), Enum.valueOf(FailoverStrategy.class, ModClusterDefinition.FAILOVER_STRATEGY.resolveModelAttribute(operationContext, model).asString()), routeParsingStrategy, routeDelimiter, builder.getMap());
        sb.setInstance((Service)service);
        sb.install();
    }

    public ModCluster getModCluster() {
        return this.modCluster;
    }
}

