/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SimplePrincipal;

public class AltClientLoginModule
implements LoginModule {
    private static final String MULTI_TREADED = "multi-threaded";
    private static final String PASSWORD_STACKING = "password-stacking";
    private static final String USE_FIRST_PASSWORD = "useFirstPass";
    private static final String PRINCIPAL_CLASS = "principalClass";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"multi-threaded", "password-stacking", "principalClass", "jboss.security.security_domain"};
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private boolean useFirstPass;
    private String username;
    private char[] password = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String passwordStacking;
        HashSet<String> validOptions = new HashSet<String>(Arrays.asList(ALL_VALID_OPTIONS));
        for (String key : options.keySet()) {
            if (validOptions.contains(key)) continue;
            PicketBoxLogger.LOGGER.warnInvalidModuleOption(key);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        PicketBoxLogger.LOGGER.debugModuleOption("jboss.security.security_domain", options.get("jboss.security.security_domain"));
        String mt = (String)options.get(MULTI_TREADED);
        if (Boolean.valueOf(mt).booleanValue()) {
            PicketBoxLogger.LOGGER.debugModuleOption(MULTI_TREADED, mt);
        }
        if ((passwordStacking = (String)options.get(PASSWORD_STACKING)) != null && passwordStacking.equalsIgnoreCase(USE_FIRST_PASSWORD)) {
            this.useFirstPass = true;
        }
        PicketBoxLogger.LOGGER.debugModuleOption(PASSWORD_STACKING, passwordStacking);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.useFirstPass) {
            return true;
        }
        if (this.callbackHandler == null) {
            throw PicketBoxMessages.MESSAGES.noCallbackHandlerAvailable();
        }
        PasswordCallback pc = new PasswordCallback(PicketBoxMessages.MESSAGES.enterPasswordMessage(), false);
        NameCallback nc = new NameCallback(PicketBoxMessages.MESSAGES.enterUsernameMessage(), "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                pc.clearPassword();
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException(uce.getLocalizedMessage());
            le.initCause(uce);
            throw le;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        Principal p = null;
        Object credential = this.password;
        if (this.useFirstPass) {
            Object user = this.sharedState.get("javax.security.auth.login.name");
            if (!(user instanceof Principal)) {
                this.username = user != null ? user.toString() : "";
                p = new SimplePrincipal(this.username);
            } else {
                p = (Principal)user;
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
        } else {
            p = new SimplePrincipal(this.username);
        }
        if (!principals.isEmpty()) {
            p = principals.iterator().next();
        }
        SecurityAssociationActions.setPrincipalInfo(p, credential, this.subject);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        int length = this.password != null ? this.password.length : 0;
        for (int n = 0; n < length; ++n) {
            this.password[n] = '\u0000';
        }
        SecurityAssociationActions.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        SecurityAssociationActions.clear();
        return true;
    }
}

