/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.jaspi.interceptor;

import jakarta.xml.soap.SOAPMessage;
import java.util.ListIterator;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.jboss.wsf.stack.cxf.jaspi.JaspiServerAuthenticator;

public class JaspiSeverOutInterceptor
extends AbstractSoapInterceptor {
    private final JaspiServerAuthenticator authManager;
    private static final SAAJOutInterceptor SAAJ_OUT = new SAAJOutInterceptor();

    public JaspiSeverOutInterceptor(JaspiServerAuthenticator authManager) {
        super("pre-stream");
        this.addAfter(StaxOutInterceptor.class.getName());
        this.authManager = authManager;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        if (!JaspiSeverOutInterceptor.chainAlreadyContainsSAAJ(message)) {
            SAAJ_OUT.handleMessage(message);
        }
        message.getInterceptorChain().add((Interceptor)new JaspiServerOutEndingInterceptor());
    }

    private static boolean chainAlreadyContainsSAAJ(SoapMessage message) {
        ListIterator listIterator = message.getInterceptorChain().getIterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof SAAJOutInterceptor)) continue;
            return true;
        }
        return false;
    }

    public class JaspiServerOutEndingInterceptor
    extends AbstractSoapInterceptor {
        public JaspiServerOutEndingInterceptor() {
            super("write-ending");
            this.addAfter(SoapOutInterceptor.SoapOutEndingInterceptor.class.getName());
        }

        public void handleMessage(SoapMessage message) throws Fault {
            if (message.getContent(SOAPMessage.class) == null) {
                return;
            }
            JaspiSeverOutInterceptor.this.authManager.secureResponse(message);
        }
    }
}

