/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common;

import java.util.List;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.impl.table.DB2SqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.GenericSqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.H2SqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.MySQLSqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.OracleSqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.PostgresqlSqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.SQLLiteSqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.SQLServerSqlManager;
import org.infinispan.persistence.jdbc.common.impl.table.SybaseSqlManager;

public interface SqlManager {
    public String getSelectStatement(List<String> var1, List<String> var2);

    public String getSelectAllStatement(List<String> var1);

    public String getDeleteStatement(List<String> var1);

    public String getDeleteAllStatement();

    public String getUpsertStatement(List<String> var1, List<String> var2);

    public String getSizeCommand();

    public static SqlManager fromDatabaseType(DatabaseType databaseType, String tableName) {
        return SqlManager.fromDatabaseType(databaseType, tableName, false);
    }

    public static SqlManager fromDatabaseType(DatabaseType databaseType, String tableName, boolean namedParameters) {
        switch (databaseType) {
            case DB2: 
            case DB2_390: {
                return new DB2SqlManager(tableName, namedParameters);
            }
            case H2: {
                return new H2SqlManager(tableName, namedParameters);
            }
            case MARIA_DB: 
            case MYSQL: {
                return new MySQLSqlManager(tableName, namedParameters);
            }
            case ORACLE: {
                return new OracleSqlManager(tableName, namedParameters);
            }
            case POSTGRES: {
                return new PostgresqlSqlManager(tableName, namedParameters);
            }
            case SQLITE: {
                return new SQLLiteSqlManager(tableName, namedParameters);
            }
            case SYBASE: {
                return new SybaseSqlManager(tableName, namedParameters);
            }
            case SQL_SERVER: {
                return new SQLServerSqlManager(tableName, namedParameters);
            }
        }
        return new GenericSqlManager(tableName, namedParameters);
    }
}

