/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logging;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Transform;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;

@MessageLogger(projectCode="WFLYLOG", length=4)
public interface LoggingLogger
extends BasicLogger {
    public static final LoggingLogger ROOT_LOGGER = (LoggingLogger)Logger.getMessageLogger(LoggingLogger.class, (String)"org.jboss.as.logging");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Closeable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="The attribute %s could not be set as it is not a configurable property value.")
    public void invalidPropertyAttribute(String var1);

    @Message(id=8, value="The path manager service does not appear to be started. Any changes may be lost as a result of this.")
    public String pathManagerServiceNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Logging profile '%s' was specified for deployment '%s' but was not found. Using system logging configuration.")
    public void loggingProfileNotFound(String var1, ResourceRoot var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="The configuration file in '%s' appears to be a J.U.L. configuration file. The log manager does not allow this type of configuration file.")
    public void julConfigurationFileFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Replacing handler '%s' during add operation. Either the handler type or the module name differs from the initial configuration.")
    public void replacingNamedHandler(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="A configurator class, '%s', is not a known configurator and will be replaced.")
    public void replacingConfigurator(@Transform(value={Transform.TransformType.GET_CLASS}) Configurator var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="The log context (%s) could not be removed for deployment %s")
    public void logContextNotRemoved(LogContext var1, String var2);

    @Deprecated
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="The per-logging deployment property (%s) has been deprecated. Please use the %s attribute to enable/disable per-deployment logging.")
    public void perDeploymentPropertyDeprecated(String var1, String var2);

    @Deprecated
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="The per-logging deployment property (%s) is being ignored because the attribute %s has been set to ignore configuration files in the deployment %s.")
    public void perLoggingDeploymentIgnored(String var1, String var2, String var3);

    @Message(id=19, value="Failed to load module '%s' for %s '%s'")
    public IllegalArgumentException cannotLoadModule(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=21, value="Class '%s' could not be found.")
    public String classNotFound(@Cause Throwable var1, String var2);

    @Message(id=23, value="Handler %s is already assigned.")
    public String handlerAlreadyDefined(String var1);

    @Message(id=25, value="Filter %s is invalid")
    public String invalidFilter(String var1);

    @Message(id=26, value="Log level %s is invalid.")
    public String invalidLogLevel(String var1);

    @Message(id=27, value="Overflow action %s is invalid.")
    public String invalidOverflowAction(String var1);

    @Message(id=28, value="Invalid size %s")
    public String invalidSize(String var1);

    @Message(id=35, value="Logger '%s' was not found.")
    public String loggerNotFound(String var1);

    @Message(id=39, value="An absolute path (%s) cannot be specified for relative-to.")
    public String invalidRelativeTo(String var1);

    @Message(id=41, value="The suffix (%s) is invalid. A suffix must be a valid date format.")
    public String invalidSuffix(String var1);

    @Message(id=42, value="Failed to configure logging using '%s' configuration file.")
    public DeploymentUnitProcessingException failedToConfigureLogging(@Cause Throwable var1, String var2);

    @Message(id=43, value="Error occurred while searching for logging configuration files.")
    public DeploymentUnitProcessingException errorProcessingLoggingConfiguration(@Cause Throwable var1);

    @Message(id=44, value="Handler %s is attached to the following handlers and cannot be removed; %s")
    public OperationFailedException handlerAttachedToHandlers(String var1, Collection<String> var2);

    @Message(id=45, value="Handler %s is attached to the following loggers and cannot be removed; %s")
    public OperationFailedException handlerAttachedToLoggers(String var1, Collection<String> var2);

    @Message(id=46, value="Cannot add handler (%s) to itself")
    public String cannotAddHandlerToSelf(String var1);

    @Message(id=47, value="The handler is closed, cannot publish to a closed handler")
    public IllegalStateException handlerClosed();

    @Message(id=48, value="Configuration for handler '%s' could not be found.")
    public String handlerConfigurationNotFound(String var1);

    @Message(id=49, value="Configuration for logger '%s' could not be found.")
    public String loggerConfigurationNotFound(String var1);

    @Message(id=50, value="Method %s on class %s is not supported")
    public UnsupportedOperationException unsupportedMethod(String var1, String var2);

    @Message(id=51, value="Failed to write configuration file %s")
    public RuntimeException failedToWriteConfigurationFile(@Cause Throwable var1, File var2);

    @Message(id=61, value="Formatter '%s' is not found")
    public String formatterNotFound(String var1);

    @Message(id=70, value="Truncated filter expression string")
    public IllegalArgumentException truncatedFilterExpression();

    @Message(id=71, value="Invalid escape found in filter expression string")
    public IllegalArgumentException invalidEscapeFoundInFilterExpression();

    @Message(id=72, value="Filter '%s' is not found")
    public OperationFailedException filterNotFound(String var1);

    @Message(id=73, value="Expected identifier next in filter expression")
    public IllegalArgumentException expectedIdentifier();

    @Message(id=74, value="Expected string next in filter expression")
    public IllegalArgumentException expectedString();

    @Message(id=75, value="Expected '%s' next in filter expression")
    public IllegalArgumentException expected(String var1);

    @Message(id=-1, value="Expected '%s' or '%s' next in filter expression")
    public IllegalArgumentException expected(String var1, String var2);

    @Message(id=76, value="Unexpected end of filter expression")
    public IllegalArgumentException unexpectedEnd();

    @Message(id=78, value="The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"")
    public IllegalStateException extensionNotInitialized();

    @Message(id=79, value="Failed to read the log file '%s'")
    public RuntimeException failedToReadLogFile(@Cause Throwable var1, String var2);

    @Message(id=80, value="File '%s' was not found and cannot be found in the %s directory.")
    public Resource.NoSuchResourceException logFileNotFound(String var1, String var2);

    @Message(id=81, value="File '%s' is not allowed to be read.")
    public OperationFailedException readNotAllowed(String var1);

    @Message(id=82, value="The suffix (%s) can not contain seconds or milliseconds.")
    public String suffixContainsMillis(String var1);

    @Message(id=83, value="Path '%s' is a directory and cannot be used as a log file.")
    public OperationFailedException invalidLogFile(String var1);

    @Message(id=84, value="Resources of type %s cannot be registered")
    public UnsupportedOperationException cannotRegisterResourceOfType(String var1);

    @Message(id=85, value="Resources of type %s cannot be removed")
    public UnsupportedOperationException cannotRemoveResourceOfType(String var1);

    @Message(id=86, value="Could not determine deployment name from the address %s.")
    public IllegalArgumentException deploymentNameNotFound(PathAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=87, value="Failed to process logging directory %s. Log files cannot be listed.")
    public void errorProcessingLogDirectory(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=88, value="Could not determine %s had any children resources.")
    public void errorDeterminingChildrenExist(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=89, value="The log manager check was skipped and the log manager system property, \"java.util.logging.manager\", does not appear to be set to \"org.jboss.logmanager.LogManager\". The current value is \"%s\". Some behavior of the logged output such as MDC and NDC may not work as expected.")
    public void unknownLogManager(String var1);

    @Once
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90, value="The following path expressions could not be resolved while attempting to determine which log files are available to be read: %s")
    public void unresolvablePathExpressions(Set<String> var1);

    @Message(id=91, value="Exception output type %s is invalid.")
    public OperationFailedException invalidExceptionOutputType(String var1);

    @Message(id=92, value="Invalid type found. Expected %s but found %s.")
    public OperationFailedException invalidType(Class<?> var1, Class<?> var2);

    @Message(id=93, value="Failed to configure SSL context for %s %s.")
    public OperationFailedException failedToConfigureSslContext(@Cause Throwable var1, String var2, String var3);

    @Message(id=94, value="Formatter name cannot end with '-wfcore-pattern-formatter'")
    public OperationFailedException illegalFormatterName();

    @Message(id=95, value="The name %s cannot be used as a filter name as it is a reserved filter name. Reserved names are: %s")
    public OperationFailedException reservedFilterName(String var1, Collection<String> var2);

    @Message(id=96, value="The name %s cannot be used as a filter name as it starts with an invalid character %s")
    public OperationFailedException invalidFilterNameStart(String var1, char var2);

    @Message(id=97, value="The name %s cannot be used as a filter name as it contains an invalid character %s")
    public OperationFailedException invalidFilterName(String var1, char var2);

    @Message(id=99, value="Usage of a log4j appender (%s) found in a custom-handler. Support for using appenders as custom handlers has been deprecated and will be removed in a future release.")
    @LogMessage(level=Logger.Level.WARN)
    public void usageOfAppender(String var1);

    @Message(id=100, value="Usage of a log4j configuration file (%s) was found in deployment %s. Support for log4j configuration files in deployments has been deprecated and will be removed in a future release.")
    @LogMessage(level=Logger.Level.WARN)
    public void usageOfLog4j1Config(String var1, String var2);
}

