/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.rts.RTSSubsystemDefinition;
import org.wildfly.extension.rts.RTSSubsystemExtension;
import org.wildfly.extension.rts.configuration.Attribute;
import org.wildfly.extension.rts.deployment.InboundBridgeDeploymentProcessor;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.extension.rts.service.CoordinatorService;
import org.wildfly.extension.rts.service.InboundBridgeService;
import org.wildfly.extension.rts.service.ParticipantService;
import org.wildfly.extension.rts.service.VolatileParticipantService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

final class RTSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final RTSSubsystemAdd INSTANCE = new RTSSubsystemAdd();

    private RTSSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (RTSLogger.ROOT_LOGGER.isTraceEnabled()) {
            RTSLogger.ROOT_LOGGER.trace("RTSSubsystemAdd.populateModel");
        }
        RTSSubsystemDefinition.SERVER.validateAndSet(operation, model);
        RTSSubsystemDefinition.HOST.validateAndSet(operation, model);
        RTSSubsystemDefinition.SOCKET_BINDING.validateAndSet(operation, model);
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (RTSLogger.ROOT_LOGGER.isTraceEnabled()) {
            RTSLogger.ROOT_LOGGER.trace("RTSSubsystemAdd.performBoottime");
        }
        this.registerCoordinatorService(context, model);
        this.registerParticipantService(context, model);
        this.registerVolatileParticipantService(context, model);
        this.registerInboundBridgeService(context);
        this.registerDeploymentProcessors(context);
    }

    private void registerInboundBridgeService(OperationContext context) {
        InboundBridgeService inboundBridgeService = new InboundBridgeService();
        ServiceBuilder inboundBridgeServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.INBOUND_BRIDGE, (Service)inboundBridgeService).addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER);
        inboundBridgeServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerCoordinatorService(OperationContext context, ModelNode model) {
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        CoordinatorService coordinatorService = new CoordinatorService();
        ServiceBuilder coordinatorServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.COORDINATOR, (Service)coordinatorService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class, coordinatorService.getInjectedSocketBinding()).addDependency(UndertowService.virtualHostName((String)serverName, (String)hostName), Host.class, coordinatorService.getInjectedHost());
        coordinatorServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerParticipantService(OperationContext context, ModelNode model) {
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        ParticipantService participantService = new ParticipantService();
        ServiceBuilder participantServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.PARTICIPANT, (Service)participantService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class, participantService.getInjectedSocketBinding()).addDependency(UndertowService.virtualHostName((String)serverName, (String)hostName), Host.class, participantService.getInjectedHost());
        participantServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerVolatileParticipantService(OperationContext context, ModelNode model) {
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        VolatileParticipantService volatileParticipantService = new VolatileParticipantService();
        ServiceBuilder volatileParticipantServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.VOLATILE_PARTICIPANT, (Service)volatileParticipantService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class, volatileParticipantService.getInjectedSocketBinding()).addDependency(UndertowService.virtualHostName((String)serverName, (String)hostName), Host.class, volatileParticipantService.getInjectedHost());
        volatileParticipantServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerDeploymentProcessors(OperationContext context) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("rts", Phase.POST_MODULE, 7424, (DeploymentUnitProcessor)new InboundBridgeDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

