/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.service.DelegatingSupplier;
import org.jboss.as.service.MBeanServices;
import org.jboss.as.service.ObjectSupplier;
import org.jboss.as.service.PropertySupplier;
import org.jboss.as.service.ReflectionUtils;
import org.jboss.as.service.ServiceAttachments;
import org.jboss.as.service.ValueFactorySupplier;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.descriptor.JBossServiceAttributeConfig;
import org.jboss.as.service.descriptor.JBossServiceConfig;
import org.jboss.as.service.descriptor.JBossServiceConstructorConfig;
import org.jboss.as.service.descriptor.JBossServiceDependencyConfig;
import org.jboss.as.service.descriptor.JBossServiceDependencyListConfig;
import org.jboss.as.service.descriptor.JBossServiceXmlDescriptor;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ParsedServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    private final ServiceName mbeanServerServiceName;

    ParsedServiceDeploymentProcessor(ServiceName mbeanServerServiceName) {
        this.mbeanServerServiceName = mbeanServerServiceName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        JBossServiceXmlDescriptor serviceXmlDescriptor = (JBossServiceXmlDescriptor)deploymentUnit.getAttachment(JBossServiceXmlDescriptor.ATTACHMENT_KEY);
        if (serviceXmlDescriptor == null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw SarLogger.ROOT_LOGGER.failedToGetAttachment("module", deploymentUnit);
        }
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        if (reflectionIndex == null) {
            throw SarLogger.ROOT_LOGGER.failedToGetAttachment("reflection index", deploymentUnit);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        List<JBossServiceConfig> serviceConfigs = serviceXmlDescriptor.getServiceConfigs();
        ServiceTarget target = phaseContext.getServiceTarget();
        Map serviceComponents = (Map)deploymentUnit.getAttachment(ServiceAttachments.SERVICE_COMPONENT_INSTANTIATORS);
        for (JBossServiceConfig serviceConfig : serviceConfigs) {
            this.addServices(target, serviceConfig, (ClassLoader)classLoader, reflectionIndex, serviceComponents != null ? (ServiceComponentInstantiator)serviceComponents.get(serviceConfig.getName()) : null, phaseContext);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addServices(ServiceTarget target, JBossServiceConfig mBeanConfig, ClassLoader classLoader, DeploymentReflectionIndex index, ServiceComponentInstantiator componentInstantiator, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String mBeanClassName = mBeanConfig.getCode();
        List<ClassReflectionIndex> mBeanClassHierarchy = ParsedServiceDeploymentProcessor.getClassHierarchy(mBeanClassName, index, classLoader);
        Object mBeanInstance = ParsedServiceDeploymentProcessor.newInstance(mBeanConfig, mBeanClassHierarchy, classLoader);
        String mBeanName = mBeanConfig.getName();
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        MBeanServices mBeanServices = new MBeanServices(mBeanName, mBeanInstance, mBeanClassHierarchy, target, componentInstantiator, deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS), classLoader, this.mbeanServerServiceName);
        JBossServiceDependencyConfig[] dependencyConfigs = mBeanConfig.getDependencyConfigs();
        this.addDependencies(dependencyConfigs, mBeanClassHierarchy, mBeanServices, mBeanInstance);
        JBossServiceDependencyListConfig[] dependencyListConfigs = mBeanConfig.getDependencyConfigLists();
        this.addDependencyLists(dependencyListConfigs, mBeanClassHierarchy, mBeanServices, mBeanInstance);
        JBossServiceAttributeConfig[] attributeConfigs = mBeanConfig.getAttributeConfigs();
        this.addAttributes(attributeConfigs, mBeanClassHierarchy, mBeanServices, classLoader, mBeanInstance);
        mBeanServices.install();
    }

    private void addDependencies(JBossServiceDependencyConfig[] dependencyConfigs, List<ClassReflectionIndex> mBeanClassHierarchy, MBeanServices mBeanServices, Object mBeanInstance) throws DeploymentUnitProcessingException {
        if (dependencyConfigs != null) {
            for (JBossServiceDependencyConfig dependencyConfig : dependencyConfigs) {
                String optionalAttributeName = dependencyConfig.getOptionalAttributeName();
                if (optionalAttributeName != null) {
                    Method setter = ReflectionUtils.getSetter(mBeanClassHierarchy, optionalAttributeName);
                    ObjectName dependencyObjectName = this.createDependencyObjectName(dependencyConfig.getDependencyName());
                    ObjectSupplier objectSupplier = new ObjectSupplier(dependencyObjectName);
                    mBeanServices.addValue(setter, objectSupplier);
                }
                mBeanServices.addDependency(dependencyConfig.getDependencyName());
            }
        }
    }

    private void addDependencyLists(JBossServiceDependencyListConfig[] dependencyListConfigs, List<ClassReflectionIndex> mBeanClassHierarchy, MBeanServices mBeanServices, Object mBeanInstance) throws DeploymentUnitProcessingException {
        if (dependencyListConfigs != null) {
            for (JBossServiceDependencyListConfig dependencyListConfig : dependencyListConfigs) {
                ArrayList<ObjectName> dependencyObjectNames = new ArrayList<ObjectName>(dependencyListConfig.getDependencyConfigs().length);
                for (JBossServiceDependencyConfig dependencyConfig : dependencyListConfig.getDependencyConfigs()) {
                    String dependencyName = dependencyConfig.getDependencyName();
                    mBeanServices.addDependency(dependencyName);
                    ObjectName dependencyObjectName = this.createDependencyObjectName(dependencyName);
                    dependencyObjectNames.add(dependencyObjectName);
                }
                String optionalAttributeName = dependencyListConfig.getOptionalAttributeName();
                if (optionalAttributeName == null) continue;
                Method setter = ReflectionUtils.getSetter(mBeanClassHierarchy, optionalAttributeName);
                ObjectSupplier objectSupplier = new ObjectSupplier(dependencyObjectNames);
                mBeanServices.addValue(setter, objectSupplier);
            }
        }
    }

    private void addAttributes(JBossServiceAttributeConfig[] attributeConfigs, List<ClassReflectionIndex> mBeanClassHierarchy, MBeanServices mBeanServices, ClassLoader classLoader, Object mBeanInstance) throws DeploymentUnitProcessingException {
        if (attributeConfigs != null) {
            for (JBossServiceAttributeConfig attributeConfig : attributeConfigs) {
                String propertyName = attributeConfig.getName();
                JBossServiceAttributeConfig.Inject injectConfig = attributeConfig.getInject();
                JBossServiceAttributeConfig.ValueFactory valueFactoryConfig = attributeConfig.getValueFactory();
                Method setter = ReflectionUtils.getSetter(mBeanClassHierarchy, propertyName);
                if (injectConfig != null) {
                    DelegatingSupplier propertySupplier = ParsedServiceDeploymentProcessor.getObjectSupplier(injectConfig);
                    mBeanServices.addAttribute(injectConfig.getBeanName(), setter, propertySupplier);
                    continue;
                }
                if (valueFactoryConfig != null) {
                    DelegatingSupplier valueFactorySupplier = ParsedServiceDeploymentProcessor.getObjectSupplier(valueFactoryConfig, classLoader);
                    mBeanServices.addAttribute(valueFactoryConfig.getBeanName(), setter, valueFactorySupplier);
                    continue;
                }
                Supplier<Object> value = ParsedServiceDeploymentProcessor.getObjectSupplier(attributeConfig, mBeanClassHierarchy);
                mBeanServices.addValue(setter, value);
            }
        }
    }

    private ObjectName createDependencyObjectName(String dependencyName) throws DeploymentUnitProcessingException {
        try {
            return new ObjectName(dependencyName);
        }
        catch (MalformedObjectNameException exception) {
            throw SarLogger.ROOT_LOGGER.malformedDependencyName(exception, dependencyName);
        }
    }

    private static DelegatingSupplier getObjectSupplier(JBossServiceAttributeConfig.Inject injectConfig) {
        return new PropertySupplier(injectConfig.getPropertyName());
    }

    private static DelegatingSupplier getObjectSupplier(JBossServiceAttributeConfig.ValueFactory valueFactory, ClassLoader classLoader) {
        String methodName = valueFactory.getMethodName();
        JBossServiceAttributeConfig.ValueFactoryParameter[] parameters = valueFactory.getParameters();
        Class[] paramTypes = new Class[parameters.length];
        Object[] args = new Object[parameters.length];
        int index = 0;
        for (JBossServiceAttributeConfig.ValueFactoryParameter parameter : parameters) {
            Class<?> attributeType;
            paramTypes[index] = attributeType = ReflectionUtils.getClass(parameter.getType(), classLoader);
            args[index] = ParsedServiceDeploymentProcessor.newValue(attributeType, parameter.getValue());
            ++index;
        }
        return new ValueFactorySupplier(methodName, paramTypes, args);
    }

    private static Supplier<Object> getObjectSupplier(JBossServiceAttributeConfig attributeConfig, List<ClassReflectionIndex> mBeanClassHierarchy) {
        String attributeName = attributeConfig.getName();
        Method setterMethod = ReflectionUtils.getSetter(mBeanClassHierarchy, attributeName);
        Class<?> setterType = setterMethod.getParameterTypes()[0];
        return new ObjectSupplier(ParsedServiceDeploymentProcessor.newValue(setterType, attributeConfig.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object newInstance(JBossServiceConfig serviceConfig, List<ClassReflectionIndex> mBeanClassHierarchy, ClassLoader deploymentClassLoader) throws DeploymentUnitProcessingException {
        ClassLoader oldTCCL = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)deploymentClassLoader);
        try {
            Object mBeanInstance;
            Constructor constructor;
            JBossServiceConstructorConfig constructorConfig = serviceConfig.getConstructorConfig();
            int paramCount = constructorConfig != null ? constructorConfig.getArguments().length : 0;
            Class[] types = new Class[paramCount];
            Object[] params = new Object[paramCount];
            if (constructorConfig != null) {
                JBossServiceConstructorConfig.Argument[] arguments = constructorConfig.getArguments();
                for (int i = 0; i < paramCount; ++i) {
                    JBossServiceConstructorConfig.Argument argument = arguments[i];
                    types[i] = ReflectionUtils.getClass(argument.getType(), deploymentClassLoader);
                    params[i] = ParsedServiceDeploymentProcessor.newValue(ReflectionUtils.getClass(argument.getType(), deploymentClassLoader), argument.getValue());
                }
            }
            if ((constructor = mBeanClassHierarchy.get(0).getConstructor(types)) == null) {
                throw SarLogger.ROOT_LOGGER.defaultConstructorNotFound(mBeanClassHierarchy.get(0).getIndexedClass());
            }
            Object object = mBeanInstance = ReflectionUtils.newInstance(constructor, params);
            return object;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    private static Object newValue(Class<?> type, String value) {
        PropertyEditor editor = PropertyEditorFinder.getInstance().find(type);
        if (editor == null) {
            SarLogger.ROOT_LOGGER.propertyNotFound(type);
            return null;
        }
        editor.setAsText(value);
        return editor.getValue();
    }

    private static List<ClassReflectionIndex> getClassHierarchy(String className, DeploymentReflectionIndex index, ClassLoader classLoader) {
        Class<?> initialClazz;
        LinkedList<ClassReflectionIndex> retVal = new LinkedList<ClassReflectionIndex>();
        for (Class<?> temp = initialClazz = ReflectionUtils.getClass(className, classLoader); temp != null && (temp == initialClazz || temp != Object.class && temp != NotificationBroadcasterSupport.class && temp != StandardMBean.class); temp = temp.getSuperclass()) {
            retVal.add(index.getClassIndex(temp));
        }
        return Collections.unmodifiableList(retVal);
    }
}

