/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.jboss.as.service.DelegatingSupplier;
import org.jboss.as.service.ReflectionUtils;
import org.jboss.as.service.logging.SarLogger;

final class PropertySupplier
extends DelegatingSupplier {
    private final String propertyName;

    PropertySupplier(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Object get() {
        Supplier objectSupplier = this.objectSupplier;
        if (objectSupplier == null) {
            throw SarLogger.ROOT_LOGGER.objectSupplierNotAvailable();
        }
        Object o = objectSupplier.get();
        if (o == null) {
            throw SarLogger.ROOT_LOGGER.objectNotAvailable();
        }
        if (this.propertyName != null) {
            try {
                return ReflectionUtils.getGetter(o.getClass(), this.propertyName).invoke(o, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw SarLogger.ROOT_LOGGER.methodIsNotAccessible(e);
            }
            catch (InvocationTargetException e) {
                throw SarLogger.ROOT_LOGGER.failedToInvokeMethod(e);
            }
        }
        return o;
    }
}

