/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.security.AllPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.security.ImmediatePermissionFactory;
import org.jboss.modules.security.LoadedPermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.wildfly.extension.security.manager.PermissionResourceDefinition;
import org.wildfly.extension.security.manager.deployment.PermissionsParseProcessor;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityManagerSubsystemAdd
extends AbstractAddStepHandler {
    static final SecurityManagerSubsystemAdd INSTANCE = new SecurityManagerSubsystemAdd();

    private SecurityManagerSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                ModelNode node = Resource.Tools.readModel((Resource)resource);
                SecurityManagerSubsystemAdd.this.launchServices(context, node);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void launchServices(OperationContext context, ModelNode node) throws OperationFailedException {
        final List<PermissionFactory> minimumSet = this.retrievePermissionSet(context, this.peek(node, "deployment-permissions", "default", "minimum-set", "default"));
        final List<PermissionFactory> maximumSet = this.retrievePermissionSet(context, this.peek(node, "deployment-permissions", "default", "maximum-set", "default"));
        if (maximumSet.isEmpty()) {
            maximumSet.add((PermissionFactory)new ImmediatePermissionFactory((Permission)new AllPermission()));
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("security-manager", Phase.PARSE, 12544, (DeploymentUnitProcessor)new PermissionsParseProcessor(minimumSet, maximumSet));
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected List<PermissionFactory> retrievePermissionSet(OperationContext context, ModelNode node) throws OperationFailedException {
        ArrayList<PermissionFactory> permissions = new ArrayList<PermissionFactory>();
        if (node != null && node.hasDefined("permission")) {
            for (Property property : node.get("permission").asPropertyList()) {
                ModelNode permissionNode = property.getValue();
                String permissionClass = PermissionResourceDefinition.CLASS.resolveModelAttribute(context, permissionNode).asString();
                String permissionName = null;
                if (permissionNode.hasDefined("name")) {
                    permissionName = PermissionResourceDefinition.NAME.resolveModelAttribute(context, permissionNode).asString();
                }
                String permissionActions = null;
                if (permissionNode.hasDefined("actions")) {
                    permissionActions = PermissionResourceDefinition.ACTIONS.resolveModelAttribute(context, permissionNode).asString();
                }
                String moduleName = null;
                if (permissionNode.hasDefined("module")) {
                    moduleName = PermissionResourceDefinition.MODULE.resolveModelAttribute(context, permissionNode).asString();
                }
                ClassLoader cl = WildFlySecurityManager.getClassLoaderPrivileged(((Object)((Object)this)).getClass());
                if (moduleName != null) {
                    try {
                        cl = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)moduleName)).getClassLoader();
                    }
                    catch (ModuleLoadException e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                }
                permissions.add((PermissionFactory)new LoadedPermissionFactory(cl, permissionClass, permissionName, permissionActions));
            }
        }
        return permissions;
    }

    protected ModelNode peek(ModelNode node, String ... args) {
        for (String arg : args) {
            if (!node.hasDefined(arg)) {
                return null;
            }
            node = node.get(arg);
        }
        return node;
    }
}

