/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.security.manager.SecurityManagerExtension;

class PermissionResourceDefinition
extends PersistentResourceDefinition {
    static final AttributeDefinition CLASS = new SimpleAttributeDefinitionBuilder("class", ModelType.STRING).setAllowNull(false).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final AttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final AttributeDefinition ACTIONS = new SimpleAttributeDefinitionBuilder("actions", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = Arrays.asList(CLASS, NAME, ACTIONS);
    static final PermissionResourceDefinition INSTANCE = new PermissionResourceDefinition();

    private PermissionResourceDefinition() {
        super(PathElement.pathElement((String)"permission"), (ResourceDescriptionResolver)SecurityManagerExtension.getResolver("permission"), (OperationStepHandler)new AbstractAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static class PermissionResourceXMLBuilder
    extends PersistentResourceXMLDescription.PersistentResourceXMLBuilder {
        protected PermissionResourceXMLBuilder(PermissionResourceDefinition definition) {
            super((PersistentResourceDefinition)definition);
        }

        public PersistentResourceXMLDescription build() {
            return new PermissionResourceXMLDescription(this.resourceDefinition, this.xmlElementName, this.xmlWrapperElement, this.attributes, new ArrayList<PersistentResourceXMLDescription>(), this.useValueAsElementName, this.noAddOperation, this.additionalOperationsGenerator);
        }
    }

    static class PermissionResourceXMLDescription
    extends PersistentResourceXMLDescription {
        protected PermissionResourceXMLDescription(PersistentResourceDefinition resourceDefinition, String xmlElementName, String xmlWrapperElement, LinkedHashMap<String, AttributeDefinition> attributes, List<PersistentResourceXMLDescription> children, boolean useValueAsElementName, boolean noAddOperation, PersistentResourceXMLDescription.AdditionalOperationsGenerator additionalOperationsGenerator) {
            super(resourceDefinition, xmlElementName, xmlWrapperElement, attributes, children, useValueAsElementName, noAddOperation, additionalOperationsGenerator);
        }

        public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
            ModelNode op = Util.createAddOperation();
            HashMap<String, String> parsedAttributes = new HashMap<String, String>();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attributeName = reader.getAttributeLocalName(i);
                String value = reader.getAttributeValue(i);
                if (!this.attributes.containsKey(attributeName)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                parsedAttributes.put(attributeName, value);
                SimpleAttributeDefinition def = (SimpleAttributeDefinition)this.attributes.get(attributeName);
                def.parseAndSetParameter(value, op, (XMLStreamReader)reader);
            }
            if (parsedAttributes.get("class") == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"class"});
            }
            String resourceName = (String)parsedAttributes.get("class") + "|" + (String)parsedAttributes.get("name") + "|" + (String)parsedAttributes.get("actions");
            PathElement path = PathElement.pathElement((String)this.resourceDefinition.getPathElement().getKey(), (String)resourceName);
            PathAddress address = parentAddress.append(new PathElement[]{path});
            op.get("address").set(address.toModelNode());
            list.add(op);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
            if (!(model = model.get(this.resourceDefinition.getPathElement().getKey())).isDefined() && !this.useValueAsElementName) {
                return;
            }
            for (Property p : model.asPropertyList()) {
                if (namespaceURI != null) {
                    writer.writeStartElement(namespaceURI, this.xmlElementName);
                } else {
                    writer.writeStartElement(this.xmlElementName);
                }
                for (AttributeDefinition def : this.attributes.values()) {
                    def.getAttributeMarshaller().marshallAsAttribute(def, p.getValue(), false, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
        }
    }
}

