/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.lang.reflect.Constructor;
import java.security.Policy;
import java.util.Properties;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.ModuleClassLoaderLocator;
import org.jboss.as.security.service.SecurityActions;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.jacc.SubjectPolicyContextHandler;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.picketbox.Version;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityBootstrapService
implements Service<Void> {
    static final String JACC_MODULE = "org.jboss.as.security.jacc-module";
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append(new String[]{"bootstrap"});
    private static final SecurityLogger log = SecurityLogger.ROOT_LOGGER;
    private final InjectedValue<ServiceModuleLoader> moduleLoaderValue = new InjectedValue();
    protected volatile Properties securityProperty;
    private Policy oldPolicy;
    private Policy jaccPolicy;
    private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";

    public void start(StartContext context) throws StartException {
        log.debugf("Starting SecurityBootstrapService", new Object[0]);
        try {
            SecurityLogger.ROOT_LOGGER.currentVersion(Version.VERSION);
            this.oldPolicy = Policy.getPolicy();
            String module = WildFlySecurityManager.getPropertyPrivileged((String)JACC_MODULE, null);
            String provider = WildFlySecurityManager.getPropertyPrivileged((String)JACC_POLICY_PROVIDER, (String)"org.jboss.security.jacc.DelegatingPolicy");
            Class<?> providerClass = this.loadClass(module, provider);
            try {
                Class[] ctorSig = new Class[]{Policy.class};
                Constructor<?> ctor = providerClass.getConstructor(ctorSig);
                Object[] ctorArgs = new Object[]{this.oldPolicy};
                this.jaccPolicy = (Policy)ctor.newInstance(ctorArgs);
            }
            catch (NoSuchMethodException e) {
                log.debugf("Provider does not support ctor(Policy)", new Object[0]);
                try {
                    this.jaccPolicy = (Policy)providerClass.newInstance();
                }
                catch (Exception e1) {
                    throw SecurityLogger.ROOT_LOGGER.unableToStartException("SecurityBootstrapService", e1);
                }
            }
            catch (Exception e) {
                throw SecurityLogger.ROOT_LOGGER.unableToStartException("SecurityBootstrapService", e);
            }
            Policy.setPolicy(this.jaccPolicy);
            this.jaccPolicy.refresh();
            SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)true);
            CallbackHandlerPolicyContextHandler chandler = new CallbackHandlerPolicyContextHandler();
            PolicyContext.registerHandler((String)"org.jboss.security.auth.spi.CallbackHandler", (PolicyContextHandler)chandler, (boolean)true);
            ClassLoaderLocatorFactory.set((ClassLoaderLocator)new ModuleClassLoaderLocator((ModuleLoader)this.moduleLoaderValue.getValue()));
        }
        catch (Exception e) {
            throw SecurityLogger.ROOT_LOGGER.unableToStartException("SecurityBootstrapService", e);
        }
    }

    private Class<?> loadClass(String module, String className) throws ClassNotFoundException, ModuleLoadException {
        if (module != null) {
            return SecurityActions.getModuleClassLoader(module).loadClass(className);
        }
        return SecurityActions.loadClass(className);
    }

    public void stop(StopContext context) {
        Set handlerKeys = PolicyContext.getHandlerKeys();
        handlerKeys.remove("org.jboss.security.auth.spi.CallbackHandler");
        handlerKeys.remove("javax.security.auth.Subject.container");
        if (this.jaccPolicy != null) {
            Policy.setPolicy(this.oldPolicy);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<ServiceModuleLoader> getServiceModuleLoaderInjectedValue() {
        return this.moduleLoaderValue;
    }
}

