/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.bridge.local;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.subsystem.bridge.impl.ChildFirstClassLoaderKernelServicesFactory;
import org.jboss.as.subsystem.bridge.impl.ClassLoaderObjectConverterImpl;
import org.jboss.as.subsystem.bridge.impl.LegacyControllerKernelServicesProxy;
import org.jboss.as.subsystem.bridge.local.ClassLoaderObjectConverter;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.dmr.ModelNode;

public class ScopedKernelServicesBootstrap {
    ClassLoader legacyChildFirstClassLoader;
    ClassLoaderObjectConverter objectConverter;

    public ScopedKernelServicesBootstrap(ClassLoader legacyChildFirstClassLoader) {
        this.legacyChildFirstClassLoader = legacyChildFirstClassLoader;
        this.objectConverter = new ClassLoaderObjectConverterImpl(this.getClass().getClassLoader(), legacyChildFirstClassLoader);
    }

    public LegacyControllerKernelServicesProxy createKernelServices(String mainSubsystemName, String extensionClassName, AdditionalInitialization additionalInit, ModelTestOperationValidatorFilter validateOpsFilter, List<ModelNode> bootOperations, ModelVersion legacyModelVersion, boolean persistXml) throws Exception {
        Object childClassLoaderKernelServices = this.createChildClassLoaderKernelServices(mainSubsystemName, extensionClassName, additionalInit, validateOpsFilter, bootOperations, legacyModelVersion, persistXml);
        return new LegacyControllerKernelServicesProxy(this.legacyChildFirstClassLoader, childClassLoaderKernelServices, this.objectConverter);
    }

    private Object createChildClassLoaderKernelServices(String mainSubsystemName, String extensionClassName, AdditionalInitialization additionalInit, ModelTestOperationValidatorFilter validateOpsFilter, List<ModelNode> bootOperations, ModelVersion legacyModelVersion, boolean persistXml) {
        try {
            Class<?> clazz = this.legacyChildFirstClassLoader.loadClass(ChildFirstClassLoaderKernelServicesFactory.class.getName());
            Method m = clazz.getMethod("create", String.class, String.class, this.legacyChildFirstClassLoader.loadClass(AdditionalInitialization.class.getName()), this.legacyChildFirstClassLoader.loadClass(ModelTestOperationValidatorFilter.class.getName()), List.class, this.legacyChildFirstClassLoader.loadClass(ModelVersion.class.getName()), Boolean.TYPE);
            ArrayList<Object> convertedBootOps = new ArrayList<Object>();
            for (int i = 0; i < bootOperations.size(); ++i) {
                ModelNode node = bootOperations.get(i);
                if (node == null) continue;
                convertedBootOps.add(this.objectConverter.convertModelNodeToChildCl(node));
            }
            Object convertedAdditionalInit = null;
            Object convertedModelVersion = this.objectConverter.convertModelVersionToChildCl(legacyModelVersion);
            Object convertedValidateOpsFilter = this.objectConverter.convertValidateOperationsFilterToChildCl(validateOpsFilter);
            return m.invoke(null, mainSubsystemName, extensionClassName, convertedAdditionalInit, convertedValidateOpsFilter, convertedBootOps, convertedModelVersion, persistXml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

