/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.txn.deployment.TransactionRollbackSetupAction;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;

public final class TransactionLeakRollbackProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"transaction", "ee-transaction-rollback-service"});
    private static final AttachmentKey<SetupAction> ATTACHMENT_KEY = AttachmentKey.create(SetupAction.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceName serviceName = deploymentUnit.getServiceName().append(SERVICE_NAME);
        RequirementServiceBuilder rsb = phaseContext.getRequirementServiceTarget().addService();
        Consumer txnRollbackSetupActionConsumer = rsb.provides(new ServiceName[]{serviceName});
        Supplier tmSupplier = rsb.requires(TransactionManagerService.INTERNAL_SERVICE_NAME);
        TransactionRollbackSetupAction service = new TransactionRollbackSetupAction(txnRollbackSetupActionConsumer, tmSupplier, serviceName);
        rsb.setInstance((Service)service);
        rsb.install();
        deploymentUnit.addToAttachmentList(Attachments.WEB_SETUP_ACTIONS, (Object)service);
        deploymentUnit.putAttachment(ATTACHMENT_KEY, (Object)service);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        SetupAction action = (SetupAction)deploymentUnit.removeAttachment(ATTACHMENT_KEY);
        deploymentUnit.getAttachmentList(Attachments.WEB_SETUP_ACTIONS).remove(action);
    }
}

