/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;

public class ModClusterLoadBalancingGroupDefinition
extends SimpleResourceDefinition {
    public static ModClusterLoadBalancingGroupDefinition INSTANCE = new ModClusterLoadBalancingGroupDefinition();
    public final OperationDefinition ENABLE_NODES = new SimpleOperationDefinition("enable-nodes", this.getResourceDescriptionResolver());
    public final OperationDefinition DISABLE_NODES = new SimpleOperationDefinition("disable-nodes", this.getResourceDescriptionResolver());
    public final OperationDefinition STOP_NODES = new SimpleOperationDefinition("stop-nodes", this.getResourceDescriptionResolver());

    ModClusterLoadBalancingGroupDefinition() {
        super(UndertowExtension.LOAD_BALANCING_GROUP, (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "mod-cluster", "balancer", "load-balancing-group"), null, null, true);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(this.ENABLE_NODES, (OperationStepHandler)new AbstractGroupOperation(){

            @Override
            protected void handleGroup(OperationContext context, ModClusterStatus.LoadBalancer balancer, String groupName, ModelNode operation) {
                for (ModClusterStatus.Node node : balancer.getNodes()) {
                    if (!groupName.equals(node.getDomain())) continue;
                    for (ModClusterStatus.Context n : node.getContexts()) {
                        n.enable();
                    }
                }
            }
        });
        resourceRegistration.registerOperationHandler(this.DISABLE_NODES, (OperationStepHandler)new AbstractGroupOperation(){

            @Override
            protected void handleGroup(OperationContext context, ModClusterStatus.LoadBalancer balancer, String groupName, ModelNode operation) {
                for (ModClusterStatus.Node node : balancer.getNodes()) {
                    if (!groupName.equals(node.getDomain())) continue;
                    for (ModClusterStatus.Context n : node.getContexts()) {
                        n.disable();
                    }
                }
            }
        });
    }

    private abstract class AbstractGroupOperation
    implements OperationStepHandler {
        private AbstractGroupOperation() {
        }

        public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String modClusterName;
            ModClusterService service;
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            int current = address.size() - 1;
            String groupName = address.getElement(current--).getValue();
            String balancerName = address.getElement(current--).getValue();
            if ((service = ModClusterResource.service(modClusterName = address.getElement(current--).getValue())) == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.LoadBalancer balancer = service.getModCluster().getController().getStatus().getLoadBalancer(balancerName);
            if (balancer == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            this.handleGroup(context, balancer, groupName, operation);
        }

        protected abstract void handleGroup(OperationContext var1, ModClusterStatus.LoadBalancer var2, String var3, ModelNode var4);
    }
}

