/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.logging;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYUT", length=4)
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)"org.wildfly.extension.undertow");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Could not initialize JSP")
    public void couldNotInitJsp(@Cause ClassNotFoundException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Undertow %s starting")
    public void serverStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Undertow %s stopping")
    public void serverStopping(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Secure listener for protocol: '%s' not found! Using non secure port!")
    public void secureListenerNotAvailableForPort(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Undertow %s listener %s listening on %s:%d")
    public void listenerStarted(String var1, String var2, String var3, int var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Undertow %s listener %s stopped, was bound to %s:%d")
    public void listenerStopped(String var1, String var2, String var3, int var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Undertow %s listener %s suspending")
    public void listenerSuspend(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Could not load class designated by HandlesTypes [%s].")
    public void cannotLoadDesignatedHandleTypes(ClassInfo var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Could not load web socket endpoint %s.")
    public void couldNotLoadWebSocketEndpoint(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Could not load web socket application config %s.")
    public void couldNotLoadWebSocketConfig(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Started server %s.")
    public void startedServer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Could not create redirect URI.")
    public void invalidRedirectURI(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Creating file handler for path '%s' with options [directory-listing: '%s', follow-symlink: '%s', case-sensitive: '%s', safe-symlink-paths: '%s']")
    public void creatingFileHandler(String var1, boolean var2, boolean var3, boolean var4, List<String> var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="Could not resolve name in absolute ordering: %s")
    public void invalidAbsoluteOrdering(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Could not delete servlet temp file %s")
    public void couldNotDeleteTempFile(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Host %s starting")
    public void hostStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Host %s stopping")
    public void hostStopping(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Clustering not supported, falling back to non-clustered session manager")
    public void clusteringNotSupported();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Registered web context: %s")
    public void registerWebapp(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=22, value="Unregistered web context: %s")
    public void unregisterWebapp(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Skipped SCI for jar: %s.")
    public void skippedSCI(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=24, value="Failed to persist session attribute %s with value %s for session %s")
    public void failedToPersistSessionAttribute(String var1, Object var2, String var3, @Cause Exception var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Failed to register policy context handler for key %s")
    public void failedToRegisterPolicyContextHandler(String var1, @Cause Exception var2);

    @Message(id=27, value="Failed to parse XML descriptor %s at [%s,%s]")
    public String failToParseXMLDescriptor(String var1, Integer var2, Integer var3);

    @Message(id=28, value="Failed to parse XML descriptor %s")
    public String failToParseXMLDescriptor(String var1);

    @Message(id=29, value="@WebServlet is only allowed at class level %s")
    public String invalidWebServletAnnotation(AnnotationTarget var1);

    @Message(id=30, value="@WebInitParam requires name and value on %s")
    public String invalidWebInitParamAnnotation(AnnotationTarget var1);

    @Message(id=31, value="@WebFilter is only allowed at class level %s")
    public String invalidWebFilterAnnotation(AnnotationTarget var1);

    @Message(id=32, value="@WebListener is only allowed at class level %s")
    public String invalidWebListenerAnnotation(AnnotationTarget var1);

    @Message(id=33, value="@RunAs needs to specify a role name on %s")
    public String invalidRunAsAnnotation(AnnotationTarget var1);

    @Message(id=34, value="@DeclareRoles needs to specify role names on %s")
    public String invalidDeclareRolesAnnotation(AnnotationTarget var1);

    @Message(id=35, value="@MultipartConfig is only allowed at class level %s")
    public String invalidMultipartConfigAnnotation(AnnotationTarget var1);

    @Message(id=36, value="@ServletSecurity is only allowed at class level %s")
    public String invalidServletSecurityAnnotation(AnnotationTarget var1);

    @Message(id=37, value="%s has the wrong component type, it cannot be used as a web component")
    public RuntimeException wrongComponentType(String var1);

    @Message(id=38, value="TLD file %s not contained in root %s")
    public String tldFileNotContainedInRoot(String var1, String var2);

    @Message(id=39, value="Failed to resolve module for deployment %s")
    public DeploymentUnitProcessingException failedToResolveModule(DeploymentUnit var1);

    @Message(id=40, value="Duplicate others in absolute ordering")
    public String invalidMultipleOthers();

    @Message(id=41, value="Invalid relative ordering")
    public String invalidRelativeOrdering();

    @Message(id=42, value="Conflict occurred processing web fragment in JAR: %s")
    public String invalidWebFragment(String var1);

    @Message(id=43, value="Relative ordering processing error with JAR: %s")
    public String invalidRelativeOrdering(String var1);

    @Message(id=44, value="Ordering includes both before and after others in JAR: %s")
    public String invalidRelativeOrderingBeforeAndAfter(String var1);

    @Message(id=45, value="Duplicate name declared in JAR: %s")
    public String invalidRelativeOrderingDuplicateName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=46, value="Unknown web fragment name declared in JAR: %s")
    public void invalidRelativeOrderingUnknownName(String var1);

    @Message(id=47, value="Relative ordering conflict with JAR: %s")
    public String invalidRelativeOrderingConflict(String var1);

    @Message(id=48, value="Failed to process WEB-INF/lib: %s")
    public String failToProcessWebInfLib(VirtualFile var1);

    @Message(id=49, value="Error loading SCI from module: %s")
    public DeploymentUnitProcessingException errorLoadingSCIFromModule(ModuleIdentifier var1, @Cause Exception var2);

    @Message(id=50, value="Unable to resolve annotation index for deployment unit: %s")
    public DeploymentUnitProcessingException unableToResolveAnnotationIndex(DeploymentUnit var1);

    @Message(id=51, value="Deployment error processing SCI for jar: %s")
    public DeploymentUnitProcessingException errorProcessingSCI(String var1, @Cause Exception var2);

    @Message(id=52, value="Security context creation failed")
    public RuntimeException failToCreateSecurityContext(@Cause Throwable var1);

    @Message(id=53, value="No security context found")
    public IllegalStateException noSecurityContext();

    @Message(id=54, value="Unknown metric %s")
    public String unknownMetric(Object var1);

    @Message(id=55, value="Null default host")
    public IllegalArgumentException nullDefaultHost();

    @Message(id=56, value="Null host name")
    public IllegalStateException nullHostName();

    @Message(id=57, value="Null parameter %s")
    public IllegalArgumentException nullParamter(String var1);

    @Message(id=58, value="Cannot activate context: %s")
    public IllegalStateException cannotActivateContext(@Cause Throwable var1, ServiceName var2);

    @Message(id=59, value="Could not construct handler for class: %s. with parameters %s")
    public RuntimeException cannotCreateHttpHandler(Class<?> var1, ModelNode var2, @Cause Throwable var3);

    @Message(id=60, value="Invalid persistent sessions directory %s")
    public StartException invalidPersistentSessionDir(File var1);

    @Message(id=61, value="Failed to create persistent sessions dir %s")
    public StartException failedToCreatePersistentSessionDir(File var1);

    @Message(id=62, value="Could not create log directory: %s")
    public StartException couldNotCreateLogDirectory(Path var1, @Cause IOException var2);

    @Message(id=63, value="Could not find the port number listening for protocol %s")
    public IllegalStateException noPortListeningForProtocol(String var1);

    @Message(id=64, value="Failed to configure handler %s")
    public RuntimeException failedToConfigureHandler(Class<?> var1, @Cause Exception var2);

    @Message(id=65, value="Handler class %s was not a handler or a wrapper")
    public IllegalArgumentException handlerWasNotAHandlerOrWrapper(Class<?> var1);

    @Message(id=66, value="Failed to configure handler %s")
    public RuntimeException failedToConfigureHandlerClass(String var1, @Cause Exception var2);

    @Message(id=67, value="Servlet class not defined for servlet %s")
    public IllegalArgumentException servletClassNotDefined(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=68, value="Error obtaining authorization helper")
    public void noAuthorizationHelper(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=69, value="Ignoring shared-session-config in jboss-all.xml in deployment %s. This entry is only valid in top level deployments.")
    public void sharedSessionConfigNotInRootDeployment(String var1);

    @Message(id=70, value="Could not load handler %s from %s module")
    public RuntimeException couldNotLoadHandlerFromModule(String var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=71, value="Jetty ALPN not found. HTTP2 and SPDY are not available. Please make sure Jetty ALPN is on the boot class path.")
    public void alpnNotFound();

    @Message(id=72, value="Could not find configured external path %s")
    public DeploymentUnitProcessingException couldNotFindExternalPath(File var1);

    @Message(id=73, value="mod_cluster advertise socket binding requires multicast address to be set")
    public StartException advertiseSocketBindingRequiresMulticastAddress();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=74, value="Could not find TLD %s")
    public void tldNotFound(String var1);

    @Message(id=75, value="Cannot register resource of type %s")
    public IllegalArgumentException cannotRegisterResourceOfType(String var1);

    @Message(id=76, value="Cannot remove resource of type %s")
    public IllegalArgumentException cannotRemoveResourceOfType(String var1);
}

