/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jacc;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.jboss.as.security.service.JaccService;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.UserDataConstraintMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;

public class WarJACCService
extends JaccService<WarMetaData> {
    private static final int PREFIX = 1;
    private static final int EXTENSION = 2;
    private static final int DEFAULT = 3;
    private static final int EXACT = 4;
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";

    public WarJACCService(String contextId, WarMetaData metaData, Boolean standalone) {
        super(contextId, (Object)metaData, standalone);
    }

    public void createPermissions(WarMetaData metaData, PolicyConfiguration pc) throws PolicyContextException {
        JBossWebMetaData jbossWebMetaData = metaData.getMergedJBossWebMetaData();
        HashMap<String, PatternInfo> patternMap = WarJACCService.qualifyURLPatterns(jbossWebMetaData);
        List secConstraints = jbossWebMetaData.getSecurityConstraints();
        if (secConstraints != null) {
            for (SecurityConstraintMetaData secConstraint : secConstraints) {
                PatternInfo info;
                List urlPatterns;
                List httpMethods;
                WebResourceCollectionsMetaData resourceCollectionsMetaData = secConstraint.getResourceCollections();
                UserDataConstraintMetaData userDataConstraintMetaData = secConstraint.getUserDataConstraint();
                if (resourceCollectionsMetaData == null) continue;
                if (secConstraint.isExcluded() || secConstraint.isUnchecked()) {
                    for (WebResourceCollectionMetaData resourceCollectionMetaData : resourceCollectionsMetaData) {
                        httpMethods = resourceCollectionMetaData.getHttpMethods();
                        urlPatterns = resourceCollectionMetaData.getUrlPatterns();
                        for (String urlPattern : urlPatterns) {
                            info = patternMap.get(urlPattern);
                            if (secConstraint.isExcluded()) {
                                info.addExcludedMethods(httpMethods);
                            }
                            if (!secConstraint.isUnchecked()) continue;
                            info.isMissingAuthConstraint = true;
                        }
                    }
                    continue;
                }
                for (WebResourceCollectionMetaData resourceCollectionMetaData : resourceCollectionsMetaData) {
                    httpMethods = resourceCollectionMetaData.getHttpMethods();
                    urlPatterns = resourceCollectionMetaData.getUrlPatterns();
                    for (String urlPattern : urlPatterns) {
                        info = patternMap.get(urlPattern);
                        HashSet<String> mappedRoles = new HashSet<String>();
                        secConstraint.getAuthConstraint().getRoleNames();
                        List authRoles = secConstraint.getAuthConstraint().getRoleNames();
                        for (String role : authRoles) {
                            if ("*".equals(role)) {
                                mappedRoles.addAll(jbossWebMetaData.getSecurityRoleNames());
                                continue;
                            }
                            mappedRoles.add(role);
                        }
                        info.addRoles(mappedRoles, httpMethods);
                        if (userDataConstraintMetaData == null || userDataConstraintMetaData.getTransportGuarantee() == null) continue;
                        info.addTransport(userDataConstraintMetaData.getTransportGuarantee().name(), httpMethods);
                    }
                }
            }
        }
        for (PatternInfo info : patternMap.values()) {
            String qurl = info.getQualifiedPattern();
            if (info.isOverridden) continue;
            String[] httpMethods = info.getExcludedMethods();
            if (httpMethods != null) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, null);
                pc.addToExcludedPolicy((Permission)wrp);
                pc.addToExcludedPolicy((Permission)wudp);
                String excludedString = "!" + WarJACCService.getCommaSeparatedString(httpMethods);
                WebResourcePermission wrp1 = new WebResourcePermission(qurl, excludedString);
                WebUserDataPermission wudp1 = new WebUserDataPermission(qurl, excludedString);
                pc.addToUncheckedPolicy((Permission)wrp1);
                pc.addToUncheckedPolicy((Permission)wudp1);
            }
            Iterator<Map.Entry<String, Set<String>>> roles = info.getRoleMethods();
            while (roles.hasNext()) {
                Map.Entry<String, Set<String>> roleMethods = roles.next();
                String role = roleMethods.getKey();
                Set<String> methods = roleMethods.getValue();
                httpMethods = methods.toArray(new String[methods.size()]);
                pc.addToRole(role, (Permission)new WebResourcePermission(qurl, httpMethods));
                int NUMBER_OF_HTTP_METHODS = 7;
                if (httpMethods == null || httpMethods.length == 7) continue;
                WebResourcePermission wrpUnchecked = new WebResourcePermission(qurl, "!" + WarJACCService.getCommaSeparatedString(httpMethods));
                pc.addToUncheckedPolicy((Permission)wrpUnchecked);
            }
            String[] missingHttpMethods = info.getMissingMethods();
            int length = missingHttpMethods.length;
            roles = info.getRoleMethods();
            if (length > 0 && !roles.hasNext()) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, missingHttpMethods);
                pc.addToUncheckedPolicy((Permission)wrp);
            } else if (!roles.hasNext()) {
                pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
            }
            if (info.isMissingAuthConstraint) {
                pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
            }
            Iterator<Map.Entry<String, Set<String>>> transportConstraints = info.getTransportMethods();
            while (transportConstraints.hasNext()) {
                Map.Entry<String, Set<String>> transportMethods = transportConstraints.next();
                String transport = transportMethods.getKey();
                Set<String> methods = transportMethods.getValue();
                httpMethods = new String[methods.size()];
                methods.toArray(httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, transport);
                pc.addToUncheckedPolicy((Permission)wudp);
                if ("NONE".equals(transport)) {
                    WebUserDataPermission wudp1 = new WebUserDataPermission(qurl, null);
                    pc.addToUncheckedPolicy((Permission)wudp1);
                    continue;
                }
                WebUserDataPermission wudpNonNull = new WebUserDataPermission(qurl, "!" + WarJACCService.getCommaSeparatedString(httpMethods));
                pc.addToUncheckedPolicy((Permission)wudpNonNull);
            }
        }
        Set declaredRoles = jbossWebMetaData.getSecurityRoleNames();
        declaredRoles.add(ANY_AUTHENTICATED_USER_ROLE);
        JBossServletsMetaData servletsMetaData = jbossWebMetaData.getServlets();
        for (JBossServletMetaData servletMetaData : servletsMetaData) {
            HashSet unrefRoles = new HashSet(declaredRoles);
            String servletName = servletMetaData.getName();
            SecurityRoleRefsMetaData roleRefsMetaData = servletMetaData.getSecurityRoleRefs();
            if (roleRefsMetaData != null) {
                for (SecurityRoleRefMetaData roleRefMetaData : roleRefsMetaData) {
                    String roleRef = roleRefMetaData.getRoleLink();
                    String roleName = roleRefMetaData.getRoleName();
                    WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, roleName);
                    pc.addToRole(roleRef, (Permission)wrrp);
                    unrefRoles.remove(roleName);
                }
            }
            for (String unrefRole : unrefRoles) {
                WebRoleRefPermission unrefP = new WebRoleRefPermission(servletName, unrefRole);
                pc.addToRole(unrefRole, (Permission)unrefP);
            }
        }
        for (String role : declaredRoles) {
            WebRoleRefPermission wrrep = new WebRoleRefPermission("", role);
            pc.addToRole(role, (Permission)wrrep);
        }
    }

    static String getCommaSeparatedString(String[] str) {
        int len = str.length;
        Arrays.sort(str);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(str[i]);
        }
        return buf.toString();
    }

    static int getPatternType(String urlPattern) {
        int type = 4;
        if (urlPattern.startsWith("*.")) {
            type = 2;
        } else if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            type = 1;
        } else if (urlPattern.equals("/")) {
            type = 3;
        }
        return type;
    }

    static HashMap<String, PatternInfo> qualifyURLPatterns(JBossWebMetaData metaData) {
        ArrayList<PatternInfo> prefixList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> extensionList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> exactList = new ArrayList<PatternInfo>();
        HashMap<String, PatternInfo> patternMap = new HashMap<String, PatternInfo>();
        PatternInfo defaultInfo = null;
        List constraints = metaData.getSecurityConstraints();
        if (constraints != null) {
            for (SecurityConstraintMetaData constraint : constraints) {
                WebResourceCollectionsMetaData resourceCollectionsMetaData = constraint.getResourceCollections();
                if (resourceCollectionsMetaData == null) continue;
                for (WebResourceCollectionMetaData resourceCollectionMetaData : resourceCollectionsMetaData) {
                    List urlPatterns = resourceCollectionMetaData.getUrlPatterns();
                    for (String url : urlPatterns) {
                        int type = WarJACCService.getPatternType(url);
                        PatternInfo info = patternMap.get(url);
                        if (info != null) continue;
                        info = new PatternInfo(url, type);
                        patternMap.put(url, info);
                        switch (type) {
                            case 1: {
                                prefixList.add(info);
                                break;
                            }
                            case 2: {
                                extensionList.add(info);
                                break;
                            }
                            case 4: {
                                exactList.add(info);
                                break;
                            }
                            case 3: {
                                defaultInfo = info;
                            }
                        }
                    }
                }
            }
        }
        for (int i = 0; i < prefixList.size(); ++i) {
            PatternInfo info = (PatternInfo)prefixList.get(i);
            for (int j = 0; j < prefixList.size(); ++j) {
                PatternInfo other;
                if (i == j || !info.matches(other = (PatternInfo)prefixList.get(j))) continue;
                info.addQualifier(other);
            }
            for (PatternInfo other : exactList) {
                if (!info.matches(other)) continue;
                info.addQualifier(other);
            }
        }
        for (PatternInfo info : extensionList) {
            for (PatternInfo other : prefixList) {
                info.addQualifier(other);
            }
            for (PatternInfo other : exactList) {
                if (!info.isExtensionFor(other)) continue;
                info.addQualifier(other);
            }
        }
        if (defaultInfo == null) {
            defaultInfo = new PatternInfo("/", 3);
            patternMap.put("/", defaultInfo);
        }
        for (PatternInfo info : patternMap.values()) {
            if (info == defaultInfo) continue;
            defaultInfo.addQualifier(info);
        }
        return patternMap;
    }

    static class PatternInfo {
        static final HashMap<String, Set<String>> ALL_TRANSPORTS = new HashMap();
        String pattern;
        String qpattern;
        ArrayList<PatternInfo> qualifiers = new ArrayList();
        int type;
        HashSet<String> excludedMethods;
        HashMap<String, Set<String>> roles;
        HashMap<String, Set<String>> transports;
        HashSet<String> allMethods = new HashSet();
        boolean isOverridden;
        boolean isMissingAuthConstraint;

        PatternInfo(String pattern, int type) {
            this.pattern = pattern;
            this.type = type;
        }

        void addExcludedMethods(List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.excludedMethods == null) {
                this.excludedMethods = new HashSet();
            }
            this.excludedMethods.addAll(methods);
            this.allMethods.addAll(methods);
        }

        public String[] getExcludedMethods() {
            String[] httpMethods = null;
            if (this.excludedMethods != null) {
                httpMethods = new String[this.excludedMethods.size()];
                this.excludedMethods.toArray(httpMethods);
            }
            return httpMethods;
        }

        public void addRoles(HashSet<String> mappedRoles, List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            this.allMethods.addAll(methods);
            if (this.roles == null) {
                this.roles = new HashMap();
            }
            for (String role : mappedRoles) {
                Set<String> roleMethods = this.roles.get(role);
                if (roleMethods == null) {
                    roleMethods = new HashSet<String>();
                    this.roles.put(role, roleMethods);
                }
                roleMethods.addAll(methods);
            }
        }

        public Iterator<Map.Entry<String, Set<String>>> getRoleMethods() {
            HashMap<String, Set<String>> tmp = this.roles;
            if (tmp == null) {
                tmp = new HashMap(0);
            }
            return tmp.entrySet().iterator();
        }

        void addTransport(String transport, List<String> httpMethods) {
            Set<String> transportMethods;
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.transports == null) {
                this.transports = new HashMap();
            }
            if ((transportMethods = this.transports.get(transport)) == null) {
                transportMethods = new HashSet<String>();
                this.transports.put(transport, transportMethods);
            }
            transportMethods.addAll(methods);
        }

        public Iterator<Map.Entry<String, Set<String>>> getTransportMethods() {
            HashMap<String, Set<String>> tmp = this.transports;
            if (tmp == null) {
                tmp = ALL_TRANSPORTS;
            }
            return tmp.entrySet().iterator();
        }

        public String[] getMissingMethods() {
            String[] httpMethods = new String[]{};
            httpMethods = this.allMethods.size() == 0 ? WebResourceCollectionMetaData.ALL_HTTP_METHOD_NAMES : WebResourceCollectionMetaData.getMissingHttpMethods(this.allMethods);
            return httpMethods;
        }

        void addQualifier(PatternInfo info) {
            if (!this.qualifiers.contains(info)) {
                if (info.type == 1 && info.matches(this)) {
                    this.isOverridden = true;
                }
                this.qualifiers.add(info);
            }
        }

        public String getQualifiedPattern() {
            if (this.qpattern == null) {
                StringBuilder tmp = new StringBuilder(this.pattern);
                for (int n = 0; n < this.qualifiers.size(); ++n) {
                    tmp.append(':');
                    PatternInfo info = this.qualifiers.get(n);
                    tmp.append(info.pattern);
                }
                this.qpattern = tmp.toString();
            }
            return this.qpattern;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            PatternInfo pi = (PatternInfo)obj;
            return this.pattern.equals(pi.pattern);
        }

        public boolean matches(PatternInfo other) {
            int matchLength = this.pattern.length() - 2;
            boolean matches = this.pattern.regionMatches(0, other.pattern, 0, matchLength);
            return matches;
        }

        public boolean isExtensionFor(PatternInfo other) {
            int offset = other.pattern.lastIndexOf(46);
            int length = this.pattern.length() - 1;
            boolean isExtensionFor = false;
            if (offset > 0) {
                isExtensionFor = this.pattern.regionMatches(1, other.pattern, offset, length);
            }
            return isExtensionFor;
        }

        public String toString() {
            StringBuilder tmp = new StringBuilder("PatternInfo[");
            tmp.append("pattern=");
            tmp.append(this.pattern);
            tmp.append(",type=");
            tmp.append(this.type);
            tmp.append(",isOverridden=");
            tmp.append(this.isOverridden);
            tmp.append(",qualifiers=");
            tmp.append(this.qualifiers);
            tmp.append("]");
            return tmp.toString();
        }

        static {
            ALL_TRANSPORTS.put("NONE", WebResourceCollectionMetaData.ALL_HTTP_METHODS);
        }
    }
}

