/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.BufferCacheDefinition;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.UndertowSubsystemAdd;
import org.wildfly.extension.undertow.filters.FailoverStrategy;
import org.wildfly.extension.undertow.filters.FilterDefinitions;
import org.wildfly.extension.undertow.handlers.HandlerDefinitions;

class UndertowRootDefinition
extends PersistentResourceDefinition {
    public static final String HTTP_INVOKER_CAPABILITY_NAME = "org.wildfly.undertow.http-invoker";
    static final RuntimeCapability<Void> HTTP_INVOKER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.http-invoker", (boolean)false, PathHandler.class).build();
    protected static final SimpleAttributeDefinition DEFAULT_VIRTUAL_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-virtual-host", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default-host"))).build();
    protected static final SimpleAttributeDefinition DEFAULT_SERVLET_CONTAINER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-servlet-container", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default"))).build();
    protected static final SimpleAttributeDefinition DEFAULT_SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-server", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default-server"))).build();
    protected static final SimpleAttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("instance-id", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode().set(new ValueExpression("${jboss.node.name}")))).build();
    protected static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("statistics-enabled", ModelType.BOOLEAN, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition DEFAULT_SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-security-domain", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("other"))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF)).setRestartAllServices()).build();
    static final ApplicationSecurityDomainDefinition APPLICATION_SECURITY_DOMAIN = ApplicationSecurityDomainDefinition.INSTANCE;
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DEFAULT_VIRTUAL_HOST, DEFAULT_SERVLET_CONTAINER, DEFAULT_SERVER, INSTANCE_ID, STATISTICS_ENABLED, DEFAULT_SECURITY_DOMAIN};
    static final PersistentResourceDefinition[] CHILDREN = new PersistentResourceDefinition[]{BufferCacheDefinition.INSTANCE, ServerDefinition.INSTANCE, ServletContainerDefinition.INSTANCE, HandlerDefinitions.INSTANCE, FilterDefinitions.INSTANCE, APPLICATION_SECURITY_DOMAIN};
    public static final UndertowRootDefinition INSTANCE = new UndertowRootDefinition();

    private UndertowRootDefinition() {
        super(UndertowExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)UndertowExtension.getResolver(new String[0]), (OperationStepHandler)new UndertowSubsystemAdd(APPLICATION_SECURITY_DOMAIN.getKnownSecurityDomainPredicate()), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return Arrays.asList(CHILDREN);
    }

    static void registerTransformers(SubsystemRegistration subsystemRegistration) {
        UndertowRootDefinition.registerTransformers_EAP_7_0_0(subsystemRegistration);
    }

    private static void registerTransformers_EAP_7_0_0(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(UndertowExtension.HTTPS_LISTENER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"security-realm"})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new String[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.getName()})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.getName()})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(UndertowExtension.HTTP_LISTENER_PATH).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new String[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.getName()})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.getName()})).end();
        builder.addChildResource(UndertowExtension.SERVER_PATH).addChildResource(UndertowExtension.HOST_PATH).rejectChildResource(UndertowExtension.PATH_HTTP_INVOKER);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(UndertowExtension.PATH_SERVLET_CONTAINER).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"disable-file-watch-service"})).end().addChildResource(UndertowExtension.PATH_WEBSOCKETS).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new String[]{"per-message-deflate"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"per-message-deflate", "deflater-level"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(UndertowExtension.PATH_FILTERS).addChildResource(PathElement.pathElement((String)"mod-cluster")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"ssl-context"})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(1)}), new String[]{"max-retries"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"max-retries"})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new String[]{"advertise-socket-binding"})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(FailoverStrategy.LOAD_BALANCED.name())}), new String[]{"failover-strategy"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"failover-strategy"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(UndertowExtension.PATH_HANDLERS).addChildResource(PathElement.pathElement((String)"reverse-proxy")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(1)}), new String[]{"max-retries"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"max-retries"})).end().addChildResource(PathElement.pathElement((String)"host")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"ssl-context"})).end();
        builder.discardChildResource(PathElement.pathElement((String)"application-security-domain"));
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)UndertowExtension.MODEL_VERSION_EAP7_0_0);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            if (attr == STATISTICS_ENABLED) {
                resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new AbstractWriteAttributeHandler<Void>(new AttributeDefinition[]{STATISTICS_ENABLED}){

                    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                        UndertowService service;
                        ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.UNDERTOW);
                        if (controller != null && (service = (UndertowService)controller.getService()) != null) {
                            service.setStatisticsEnabled(resolvedValue.asBoolean());
                        }
                        return false;
                    }

                    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
                        UndertowService service;
                        ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.UNDERTOW);
                        if (controller != null && (service = (UndertowService)controller.getService()) != null) {
                            service.setStatisticsEnabled(valueToRestore.asBoolean());
                        }
                    }
                });
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(HTTP_INVOKER_RUNTIME_CAPABILITY);
    }
}

