/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.security.jacc.PolicyConfiguration;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.security.deployment.SecurityAttachments;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.JaccService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ExplodedDeploymentMarker;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.security.SecurityUtil;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.ControlPointService;
import org.wildfly.extension.requestcontroller.RequestControllerActivationMarker;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;
import org.wildfly.extension.undertow.deployment.UndertowHandlersDeploymentProcessor;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.jacc.WarJACCDeployer;
import org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecBuilder;
import org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecBuilderValue;
import org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilder;
import org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilderValue;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;
import org.wildfly.extension.undertow.session.SimpleDistributableSessionManagerConfiguration;
import org.wildfly.extension.undertow.session.SimpleSessionIdentifierCodecService;

public class UndertowDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String defaultServer;
    private final String defaultHost;
    private final String defaultContainer;
    private final String defaultSecurityDomain;
    private final Predicate<String> knownSecurityDomain;
    private final DefaultDeploymentMappingProvider defaultModuleMappingProvider;

    public UndertowDeploymentProcessor(String defaultHost, String defaultContainer, String defaultServer, String defaultSecurityDomain, Predicate<String> knownSecurityDomain) {
        this.defaultHost = defaultHost;
        this.defaultSecurityDomain = defaultSecurityDomain;
        this.defaultModuleMappingProvider = DefaultDeploymentMappingProvider.instance();
        if (defaultHost == null) {
            throw UndertowLogger.ROOT_LOGGER.nullDefaultHost();
        }
        this.defaultContainer = defaultContainer;
        this.defaultServer = defaultServer;
        this.knownSecurityDomain = knownSecurityDomain;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String defaultHostForDeployment;
        String defaultServerForDeployment;
        WarMetaData warMetaData;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (RequestControllerActivationMarker.isRequestControllerEnabled((DeploymentUnit)deploymentUnit) && deploymentUnit.getParent() == null) {
            ControlPointService.install((ServiceTarget)phaseContext.getServiceTarget(), (String)deploymentUnit.getName(), (String)"undertow");
        }
        if ((warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY)) == null) {
            return;
        }
        String deploymentName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName() + "." + deploymentUnit.getName();
        Map.Entry<String, String> severHost = this.defaultModuleMappingProvider.getMapping(deploymentName);
        if (severHost != null) {
            defaultServerForDeployment = severHost.getKey();
            defaultHostForDeployment = severHost.getValue();
        } else {
            defaultServerForDeployment = this.defaultServer;
            defaultHostForDeployment = this.defaultHost;
        }
        String serverInstanceName = warMetaData.getMergedJBossWebMetaData().getServerInstanceName() == null ? defaultServerForDeployment : warMetaData.getMergedJBossWebMetaData().getServerInstanceName();
        String hostName = this.hostNameOfDeployment(warMetaData, defaultHostForDeployment);
        this.processDeployment(warMetaData, deploymentUnit, phaseContext.getServiceTarget(), deploymentName, hostName, serverInstanceName);
    }

    private String hostNameOfDeployment(WarMetaData metaData, String defaultHost) {
        String hostName;
        Collection<Object> hostNames = null;
        if (metaData.getMergedJBossWebMetaData() != null) {
            hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        }
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw UndertowLogger.ROOT_LOGGER.nullHostName();
        }
        return hostName;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processDeployment(WarMetaData warMetaData, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, String deploymentName, String hostName, String serverInstanceName) throws DeploymentUnitProcessingException {
        WarJACCDeployer deployer;
        JaccService jaccService;
        SharedSessionManagerConfig sharedSessionManagerConfig;
        ResourceRoot deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentRoot = deploymentResourceRoot.getRoot();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException((Throwable)UndertowLogger.ROOT_LOGGER.failedToResolveModule(deploymentUnit));
        }
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        List setupActions = deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS);
        ScisMetaData scisMetaData = (ScisMetaData)deploymentUnit.getAttachment(ScisMetaData.ATTACHMENT_KEY);
        HashSet<ServiceName> dependentComponents = new HashSet<ServiceName>();
        List components = deploymentUnit.getAttachmentList(WebComponentDescription.WEB_COMPONENTS);
        Set failed = (Set)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.FAILED_COMPONENTS);
        for (ServiceName component : components) {
            if (failed.contains(component)) continue;
            dependentComponents.add(component);
        }
        String servletContainerName = metaData.getServletContainerName();
        if (servletContainerName == null) {
            servletContainerName = this.defaultContainer;
        }
        boolean componentRegistryExists = true;
        ComponentRegistry componentRegistry = (ComponentRegistry)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.COMPONENT_REGISTRY);
        if (componentRegistry == null) {
            componentRegistryExists = false;
            componentRegistry = new ComponentRegistry(null);
        }
        WebInjectionContainer injectionContainer = new WebInjectionContainer((ClassLoader)module.getClassLoader(), componentRegistry);
        String jaccContextId = metaData.getJaccContextID();
        if (jaccContextId == null) {
            jaccContextId = deploymentUnit.getName();
        }
        if (deploymentUnit.getParent() != null) {
            jaccContextId = deploymentUnit.getParent().getName() + "!" + jaccContextId;
        }
        String pathName = UndertowDeploymentProcessor.pathNameOfDeployment(deploymentUnit, metaData);
        boolean securityEnabled = deploymentUnit.hasAttachment(SecurityAttachments.SECURITY_ENABLED);
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain == null) {
            metaDataSecurityDomain = this.getJBossAppSecurityDomain(deploymentUnit);
        }
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        String securityDomain = securityEnabled ? (metaDataSecurityDomain == null ? this.defaultSecurityDomain : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain)) : null;
        HashSet additionalDependencies = new HashSet();
        for (SetupAction setupAction : setupActions) {
            Set dependencies = setupAction.dependencies();
            if (dependencies == null) continue;
            additionalDependencies.addAll(dependencies);
        }
        SharedSessionManagerConfig sharedSessionManagerConfig2 = sharedSessionManagerConfig = deploymentUnit.getParent() != null ? (SharedSessionManagerConfig)deploymentUnit.getParent().getAttachment(UndertowAttachments.SHARED_SESSION_MANAGER_CONFIG) : null;
        if (!deploymentResourceRoot.isUsePhysicalCodeSource()) {
            try {
                deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("org.apache.jasper.Constants.CODE_SOURCE_ATTRIBUTE_NAME", (Object)deploymentRoot.toURL()));
            }
            catch (MalformedURLException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("org.apache.jasper.Constants.PERMISSION_COLLECTION_ATTRIBUTE_NAME", deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE_PERMISSIONS)));
        additionalDependencies.addAll(warMetaData.getAdditionalDependencies());
        ServiceName hostServiceName = UndertowService.virtualHostName(serverInstanceName, hostName);
        ServiceName deploymentServiceName = UndertowService.deploymentServiceName(serverInstanceName, hostName, pathName);
        TldsMetaData tldsMetaData = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        UndertowDeploymentInfoService undertowDeploymentInfoService = UndertowDeploymentInfoService.builder().setAttributes(deploymentUnit.getAttachmentList(ServletContextAttribute.ATTACHMENT_KEY)).setContextPath(pathName).setDeploymentName(deploymentName).setDeploymentRoot(deploymentRoot).setMergedMetaData(warMetaData.getMergedJBossWebMetaData()).setModule(module).setScisMetaData(scisMetaData).setJaccContextId(jaccContextId).setSecurityDomain(securityDomain).setSharedTlds(tldsMetaData == null ? Collections.emptyList() : tldsMetaData.getSharedTlds(deploymentUnit)).setTldsMetaData(tldsMetaData).setSetupActions(setupActions).setSharedSessionManagerConfig(sharedSessionManagerConfig).setOverlays(warMetaData.getOverlays()).setExpressionFactoryWrappers(deploymentUnit.getAttachmentList(ExpressionFactoryWrapper.ATTACHMENT_KEY)).setPredicatedHandlers((List)deploymentUnit.getAttachment(UndertowHandlersDeploymentProcessor.PREDICATED_HANDLERS)).setInitialHandlerChainWrappers(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_INITIAL_HANDLER_CHAIN_WRAPPERS)).setInnerHandlerChainWrappers(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_INNER_HANDLER_CHAIN_WRAPPERS)).setOuterHandlerChainWrappers(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_OUTER_HANDLER_CHAIN_WRAPPERS)).setThreadSetupActions(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_THREAD_SETUP_ACTIONS)).setServletExtensions(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_SERVLET_EXTENSIONS)).setExplodedDeployment(ExplodedDeploymentMarker.isExplodedDeployment((DeploymentUnit)deploymentUnit)).setWebSocketDeploymentInfo((WebSocketDeploymentInfo)deploymentUnit.getAttachment(UndertowAttachments.WEB_SOCKET_DEPLOYMENT_INFO)).setTempDir(warMetaData.getTempDir()).setExternalResources(deploymentUnit.getAttachmentList(UndertowAttachments.EXTERNAL_RESOURCES)).setAllowSuspendedRequests(deploymentUnit.getAttachmentList(UndertowAttachments.ALLOW_REQUEST_WHEN_SUSPENDED)).createUndertowDeploymentInfoService();
        ServiceName deploymentInfoServiceName = deploymentServiceName.append(UndertowDeploymentInfoService.SERVICE_NAME);
        ServiceBuilder infoBuilder = serviceTarget.addService(deploymentInfoServiceName, (Service)undertowDeploymentInfoService).addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{servletContainerName}), ServletContainerService.class, undertowDeploymentInfoService.getContainer()).addDependency(UndertowService.UNDERTOW, UndertowService.class, undertowDeploymentInfoService.getUndertowService()).addDependency(hostServiceName, Host.class, undertowDeploymentInfoService.getHost()).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, undertowDeploymentInfoService.getServerEnvironmentInjectedValue()).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, undertowDeploymentInfoService.getSuspendControllerInjectedValue()).addDependencies(additionalDependencies);
        if (securityDomain != null) {
            if (this.knownSecurityDomain.test(securityDomain)) {
                infoBuilder.addDependency(((CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityServiceName("org.wildfly.extension.undertow.application-security-domain", new String[]{securityDomain}), BiFunction.class, undertowDeploymentInfoService.getSecurityFunctionInjector());
            } else {
                infoBuilder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), SecurityDomainContext.class, undertowDeploymentInfoService.getSecurityDomainContextValue());
            }
        }
        if (RequestControllerActivationMarker.isRequestControllerEnabled((DeploymentUnit)deploymentUnit)) {
            String topLevelName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName();
            infoBuilder.addDependency(ControlPointService.serviceName((String)topLevelName, (String)"undertow"), ControlPoint.class, undertowDeploymentInfoService.getControlPointInjectedValue());
        }
        HashSet<String> seenExecutors = new HashSet<String>();
        if (metaData.getExecutorName() != null) {
            InjectedValue executor = new InjectedValue();
            infoBuilder.addDependency(IOServices.WORKER.append(new String[]{metaData.getExecutorName()}), Executor.class, (Injector)executor);
            undertowDeploymentInfoService.addInjectedExecutor(metaData.getExecutorName(), (InjectedValue<Executor>)executor);
            seenExecutors.add(metaData.getExecutorName());
        }
        if (metaData.getServlets() != null) {
            for (JBossServletMetaData servlet : metaData.getServlets()) {
                if (servlet.getExecutorName() == null || seenExecutors.contains(servlet.getExecutorName())) continue;
                InjectedValue executor = new InjectedValue();
                infoBuilder.addDependency(IOServices.WORKER.append(new String[]{servlet.getExecutorName()}), Executor.class, (Injector)executor);
                undertowDeploymentInfoService.addInjectedExecutor(servlet.getExecutorName(), (InjectedValue<Executor>)executor);
                seenExecutors.add(servlet.getExecutorName());
            }
        }
        if (componentRegistryExists) {
            infoBuilder.addDependency(ComponentRegistry.serviceName((DeploymentUnit)deploymentUnit), ComponentRegistry.class, undertowDeploymentInfoService.getComponentRegistryInjectedValue());
        } else {
            undertowDeploymentInfoService.getComponentRegistryInjectedValue().setValue((Value)new ImmediateValue((Object)componentRegistry));
        }
        if (sharedSessionManagerConfig != null) {
            infoBuilder.addDependency(deploymentUnit.getParent().getServiceName().append(SharedSessionManagerConfig.SHARED_SESSION_MANAGER_SERVICE_NAME), SessionManagerFactory.class, undertowDeploymentInfoService.getSessionManagerFactoryInjector());
            infoBuilder.addDependency(deploymentUnit.getParent().getServiceName().append(SharedSessionManagerConfig.SHARED_SESSION_IDENTIFIER_CODEC_SERVICE_NAME), SessionIdentifierCodec.class, undertowDeploymentInfoService.getSessionIdentifierCodecInjector());
        } else {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
            ServiceName sessionManagerFactoryServiceName = UndertowDeploymentProcessor.installSessionManagerFactory(support, serviceTarget, deploymentServiceName, deploymentName, module, metaData, (ServletContainerService)deploymentUnit.getAttachment(UndertowAttachments.SERVLET_CONTAINER_SERVICE));
            infoBuilder.addDependency(sessionManagerFactoryServiceName, SessionManagerFactory.class, undertowDeploymentInfoService.getSessionManagerFactoryInjector());
            ServiceName sessionIdentifierCodecServiceName = UndertowDeploymentProcessor.installSessionIdentifierCodec(serviceTarget, deploymentServiceName, deploymentName, metaData);
            infoBuilder.addDependency(sessionIdentifierCodecServiceName, SessionIdentifierCodec.class, undertowDeploymentInfoService.getSessionIdentifierCodecInjector());
        }
        infoBuilder.install();
        boolean isWebappBundle = deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.OSGI_MANIFEST);
        UndertowDeploymentService service = new UndertowDeploymentService(injectionContainer, !isWebappBundle);
        ServiceBuilder builder = serviceTarget.addService(deploymentServiceName, (Service)service).addDependencies(dependentComponents).addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{this.defaultContainer}), ServletContainerService.class, service.getContainer()).addDependency(hostServiceName, Host.class, service.getHost()).addDependencies((Iterable)deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.WEB_DEPENDENCIES)).addDependency(deploymentInfoServiceName, DeploymentInfo.class, service.getDeploymentInfoInjectedValue());
        Services.addServerExecutorDependency((ServiceBuilder)builder, service.getServerExecutorInjector(), (boolean)false);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)deploymentServiceName);
        if (securityEnabled && (jaccService = (deployer = new WarJACCDeployer()).deploy(deploymentUnit, jaccContextId)) != null) {
            ServiceName jaccServiceName = deploymentUnit.getServiceName().append(JaccService.SERVICE_NAME);
            ServiceBuilder jaccBuilder = serviceTarget.addService(jaccServiceName, (Service)jaccService);
            if (deploymentUnit.getParent() != null) {
                DeploymentUnit parentDU = deploymentUnit.getParent();
                jaccBuilder.addDependency(parentDU.getServiceName().append(JaccService.SERVICE_NAME), PolicyConfiguration.class, jaccService.getParentPolicyInjector());
            }
            jaccBuilder.addDependency(deploymentServiceName);
            jaccBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        }
        if (isWebappBundle) {
            UndertowDeploymentService.ContextActivatorImpl activator = new UndertowDeploymentService.ContextActivatorImpl((ServiceController<UndertowDeploymentService>)builder.install());
            deploymentUnit.putAttachment(ContextActivator.ATTACHMENT_KEY, (Object)activator);
            deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.BUNDLE_ACTIVE_DEPENDENCIES, (Object)deploymentServiceName);
        } else {
            builder.install();
        }
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        ModelNode node = deploymentResourceSupport.getDeploymentSubsystemModel("undertow");
        node.get(DeploymentDefinition.CONTEXT_ROOT.getName()).set("".equals(pathName) ? "/" : pathName);
        node.get(DeploymentDefinition.VIRTUAL_HOST.getName()).set(hostName);
        node.get(DeploymentDefinition.SERVER.getName()).set(serverInstanceName);
        this.processManagement(deploymentUnit, metaData);
    }

    private static ServiceName installSessionManagerFactory(CapabilityServiceSupport support, ServiceTarget target, ServiceName deploymentServiceName, String deploymentName, Module module, JBossWebMetaData metaData, ServletContainerService servletContainerService) {
        Integer maxActiveSessions = metaData.getMaxActiveSessions();
        if (maxActiveSessions == null && servletContainerService != null) {
            maxActiveSessions = servletContainerService.getMaxSessions();
        }
        ServiceName name = deploymentServiceName.append(new String[]{"session"});
        if (metaData.getDistributable() != null) {
            DistributableSessionManagerFactoryBuilder sessionManagerFactoryBuilder = new DistributableSessionManagerFactoryBuilderValue().getValue();
            if (sessionManagerFactoryBuilder != null) {
                sessionManagerFactoryBuilder.build(support, target, name, new SimpleDistributableSessionManagerConfiguration(maxActiveSessions, metaData.getReplicationConfig(), deploymentName, module)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                return name;
            }
            UndertowLogger.ROOT_LOGGER.clusteringNotSupported();
        }
        InMemorySessionManagerFactory factory = maxActiveSessions != null ? new InMemorySessionManagerFactory(maxActiveSessions.intValue()) : new InMemorySessionManagerFactory();
        target.addService(name, (Service)new ValueService((Value)new ImmediateValue((Object)factory))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return name;
    }

    private static ServiceName installSessionIdentifierCodec(ServiceTarget target, ServiceName deploymentServiceName, String deploymentName, JBossWebMetaData metaData) {
        DistributableSessionIdentifierCodecBuilder sessionIdentifierCodecBuilder;
        ServiceName name = deploymentServiceName.append(new String[]{"codec"});
        if (metaData.getDistributable() != null && (sessionIdentifierCodecBuilder = new DistributableSessionIdentifierCodecBuilderValue().getValue()) != null) {
            sessionIdentifierCodecBuilder.build(target, name, deploymentName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            return name;
        }
        SimpleSessionIdentifierCodecService.build(target, name).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return name;
    }

    static String pathNameOfDeployment(DeploymentUnit deploymentUnit, JBossWebMetaData metaData) {
        String pathName;
        if (metaData.getContextRoot() == null) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            pathName = description != null ? "/" + description.getModuleName() : "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        return pathName;
    }

    void processManagement(DeploymentUnit unit, JBossWebMetaData metaData) {
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)unit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (JBossServletMetaData servlet : metaData.getServlets()) {
            try {
                String name = servlet.getName();
                ModelNode node = deploymentResourceSupport.getDeploymentSubModel("undertow", PathElement.pathElement((String)"servlet", (String)name));
                node.get("servlet-class").set(servlet.getServletClass());
                node.get("servlet-name").set(servlet.getServletName());
            }
            catch (Exception e) {}
        }
    }

    private String getJBossAppSecurityDomain(DeploymentUnit deploymentUnit) {
        EarMetaData jbossAppMetaData;
        String securityDomain = null;
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent != null && (jbossAppMetaData = (EarMetaData)parent.getAttachment(Attachments.EAR_METADATA)) instanceof JBossAppMetaData) {
            securityDomain = ((JBossAppMetaData)jbossAppMetaData).getSecurityDomain();
        }
        return securityDomain;
    }
}

