/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.digest;

import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NonceManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestQop;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.digest.DigestCredential;

public class DigestAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String DEFAULT_NAME = "DIGEST";
    private static final String DIGEST_PREFIX = Headers.DIGEST + " ";
    private static final int PREFIX_LENGTH = DIGEST_PREFIX.length();
    private static final String OPAQUE_VALUE = "00000000000000000000000000000000";
    private static final byte COLON = 58;
    private final String mechanismName;
    private final IdentityManager identityManager;
    private static final Set<DigestAuthorizationToken> MANDATORY_REQUEST_TOKENS;
    private final List<DigestAlgorithm> supportedAlgorithms;
    private final List<DigestQop> supportedQops;
    private final String qopString;
    private final String realmName;
    private final String domain;
    private final NonceManager nonceManager;

    public DigestAuthenticationMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager) {
        this(supportedAlgorithms, supportedQops, realmName, domain, nonceManager, DEFAULT_NAME);
    }

    public DigestAuthenticationMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager, String mechanismName) {
        this(supportedAlgorithms, supportedQops, realmName, domain, nonceManager, mechanismName, null);
    }

    public DigestAuthenticationMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager, String mechanismName, IdentityManager identityManager) {
        this.supportedAlgorithms = supportedAlgorithms;
        this.supportedQops = supportedQops;
        this.realmName = realmName;
        this.domain = domain;
        this.nonceManager = nonceManager;
        this.mechanismName = mechanismName;
        this.identityManager = identityManager;
        if (!supportedQops.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<DigestQop> it = supportedQops.iterator();
            sb.append(it.next().getToken());
            while (it.hasNext()) {
                sb.append(",").append(it.next().getToken());
            }
            this.qopString = sb.toString();
        } else {
            this.qopString = null;
        }
    }

    public DigestAuthenticationMechanism(String realmName, String domain, String mechanismName) {
        this(realmName, domain, mechanismName, null);
    }

    public DigestAuthenticationMechanism(String realmName, String domain, String mechanismName, IdentityManager identityManager) {
        this(Collections.singletonList(DigestAlgorithm.MD5), Collections.singletonList(DigestQop.AUTH), realmName, domain, (NonceManager)new SimpleNonceManager(), DEFAULT_NAME, identityManager);
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Iterator iterator;
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null && (iterator = authHeaders.iterator()).hasNext()) {
            String current = (String)iterator.next();
            if (current.startsWith(DIGEST_PREFIX)) {
                String digestChallenge = current.substring(PREFIX_LENGTH);
                try {
                    DigestContext context = new DigestContext();
                    Map parsedHeader = DigestAuthorizationToken.parseHeader((String)digestChallenge);
                    context.setMethod(exchange.getRequestMethod().toString());
                    context.setParsedHeader(parsedHeader);
                    exchange.putAttachment(DigestContext.ATTACHMENT_KEY, (Object)context);
                    return this.handleDigestHeader(exchange, securityContext);
                }
                catch (Exception e) {
                    UndertowLogger.ROOT_LOGGER.unexceptedAuthentificationError(e.getLocalizedMessage(), e);
                }
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome handleDigestHeader(HttpServerExchange exchange, SecurityContext securityContext) {
        DigestAlgorithm algorithm;
        DigestContext context = (DigestContext)exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        HashSet<DigestAuthorizationToken> mandatoryTokens = new HashSet<DigestAuthorizationToken>(MANDATORY_REQUEST_TOKENS);
        if (!this.supportedAlgorithms.contains(DigestAlgorithm.MD5)) {
            mandatoryTokens.add(DigestAuthorizationToken.ALGORITHM);
        }
        if (!this.supportedQops.isEmpty() && !this.supportedQops.contains(DigestQop.AUTH)) {
            mandatoryTokens.add(DigestAuthorizationToken.MESSAGE_QOP);
        }
        DigestQop qop = null;
        if (parsedHeader.containsKey(DigestAuthorizationToken.MESSAGE_QOP)) {
            qop = DigestQop.forName((String)parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP));
            if (qop == null || !this.supportedQops.contains(qop)) {
                io.undertow.UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.MESSAGE_QOP.getName(), parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP));
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            context.setQop(qop);
            mandatoryTokens.add(DigestAuthorizationToken.CNONCE);
            mandatoryTokens.add(DigestAuthorizationToken.NONCE_COUNT);
        }
        mandatoryTokens.removeAll(parsedHeader.keySet());
        if (mandatoryTokens.size() > 0) {
            for (DigestAuthorizationToken currentToken : mandatoryTokens) {
                io.undertow.UndertowLogger.REQUEST_LOGGER.missingAuthorizationToken(currentToken.getName());
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (!this.realmName.equals(parsedHeader.get(DigestAuthorizationToken.REALM))) {
            io.undertow.UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.REALM.getName(), parsedHeader.get(DigestAuthorizationToken.REALM));
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.OPAQUE) && !OPAQUE_VALUE.equals(parsedHeader.get(DigestAuthorizationToken.OPAQUE))) {
            io.undertow.UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.OPAQUE.getName(), parsedHeader.get(DigestAuthorizationToken.OPAQUE));
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.ALGORITHM)) {
            algorithm = DigestAlgorithm.forName((String)parsedHeader.get(DigestAuthorizationToken.ALGORITHM));
            if (algorithm == null || !this.supportedAlgorithms.contains(algorithm)) {
                io.undertow.UndertowLogger.REQUEST_LOGGER.invalidTokenReceived(DigestAuthorizationToken.ALGORITHM.getName(), parsedHeader.get(DigestAuthorizationToken.ALGORITHM));
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        } else {
            algorithm = DigestAlgorithm.MD5;
        }
        try {
            context.setAlgorithm(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            io.undertow.UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest((Throwable)e);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        String userName = parsedHeader.get(DigestAuthorizationToken.USERNAME);
        IdentityManager identityManager = this.getIdentityManager(securityContext);
        if (algorithm.isSession()) {
            throw new IllegalStateException("Not yet implemented.");
        }
        DigestCredentialImpl credential = new DigestCredentialImpl(context);
        Account account = identityManager.verify(userName, (Credential)credential);
        if (account == null) {
            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.mechanismName);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (!this.validateNonceUse(context, parsedHeader, exchange)) {
            context.markStale();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        securityContext.authenticationComplete(account, this.mechanismName, true);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    private boolean validateNonceUse(DigestContext context, Map<DigestAuthorizationToken, String> parsedHeader, HttpServerExchange exchange) {
        String suppliedNonce = parsedHeader.get(DigestAuthorizationToken.NONCE);
        int nonceCount = -1;
        if (parsedHeader.containsKey(DigestAuthorizationToken.NONCE_COUNT)) {
            String nonceCountHex = parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT);
            nonceCount = Integer.parseInt(nonceCountHex, 16);
        }
        context.setNonce(suppliedNonce);
        return this.nonceManager.validateNonce(suppliedNonce, nonceCount, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createHA2Auth(DigestContext context, Map<DigestAuthorizationToken, String> parsedHeader) {
        byte[] method = context.getMethod().getBytes(StandardCharsets.UTF_8);
        byte[] digestUri = parsedHeader.get(DigestAuthorizationToken.DIGEST_URI).getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = context.getDigest();
        try {
            digest.update(method);
            digest.update((byte)58);
            digest.update(digestUri);
            byte[] byArray = HexConverter.convertToHexBytes((byte[])digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        DigestContext context = (DigestContext)exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        boolean stale = context == null ? false : context.isStale();
        StringBuilder rb = new StringBuilder(DIGEST_PREFIX);
        rb.append(Headers.REALM.toString()).append("=\"").append(this.realmName).append("\",");
        rb.append(Headers.DOMAIN.toString()).append("=\"").append(this.domain).append("\",");
        rb.append(Headers.NONCE.toString()).append("=\"").append(this.nonceManager.nextNonce(null, exchange)).append("\",");
        rb.append(Headers.OPAQUE.toString()).append("=\"00000000000000000000000000000000\"");
        if (stale) {
            rb.append(",stale=true");
        }
        if (this.supportedAlgorithms.size() > 0) {
            rb.append(",").append(Headers.ALGORITHM.toString()).append("=%s");
        }
        if (this.qopString != null) {
            rb.append(",").append(Headers.QOP.toString()).append("=\"").append(this.qopString).append("\"");
        }
        String theChallenge = rb.toString();
        HeaderMap responseHeader = exchange.getResponseHeaders();
        if (this.supportedAlgorithms.isEmpty()) {
            responseHeader.add(Headers.WWW_AUTHENTICATE, theChallenge);
        } else {
            for (DigestAlgorithm current : this.supportedAlgorithms) {
                responseHeader.add(Headers.WWW_AUTHENTICATE, String.format(theChallenge, current.getToken()));
            }
        }
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    static {
        HashSet<DigestAuthorizationToken> mandatoryTokens = new HashSet<DigestAuthorizationToken>();
        mandatoryTokens.add(DigestAuthorizationToken.USERNAME);
        mandatoryTokens.add(DigestAuthorizationToken.REALM);
        mandatoryTokens.add(DigestAuthorizationToken.NONCE);
        mandatoryTokens.add(DigestAuthorizationToken.DIGEST_URI);
        mandatoryTokens.add(DigestAuthorizationToken.RESPONSE);
        MANDATORY_REQUEST_TOKENS = Collections.unmodifiableSet(mandatoryTokens);
    }

    private class DigestCredentialImpl
    implements DigestCredential {
        private final DigestContext context;

        private DigestCredentialImpl(DigestContext digestContext) {
            this.context = digestContext;
        }

        @Override
        public String getClientDigest() {
            return this.context.getParsedHeader().get(DigestAuthorizationToken.RESPONSE);
        }

        @Override
        public String getNonce() {
            return this.context.getParsedHeader().get(DigestAuthorizationToken.NONCE);
        }

        @Override
        public String getNonceCount() {
            return this.context.getParsedHeader().get(DigestAuthorizationToken.NONCE_COUNT);
        }

        @Override
        public String getClientNonce() {
            return this.context.getParsedHeader().get(DigestAuthorizationToken.CNONCE);
        }

        @Override
        public String getQop() {
            return this.context.getQop().getToken();
        }

        @Override
        public String getRealm() {
            return DigestAuthenticationMechanism.this.realmName;
        }

        @Override
        public String getHA2() {
            byte[] ha2 = DigestAuthenticationMechanism.this.createHA2Auth(this.context, this.context.getParsedHeader());
            return new String(ha2, StandardCharsets.UTF_8);
        }
    }

    private static class DigestContext {
        static final AttachmentKey<DigestContext> ATTACHMENT_KEY = AttachmentKey.create(DigestContext.class);
        private String method;
        private String nonce;
        private DigestQop qop;
        private MessageDigest digest;
        private boolean stale = false;
        Map<DigestAuthorizationToken, String> parsedHeader;

        private DigestContext() {
        }

        String getMethod() {
            return this.method;
        }

        void setMethod(String method) {
            this.method = method;
        }

        boolean isStale() {
            return this.stale;
        }

        void markStale() {
            this.stale = true;
        }

        String getNonce() {
            return this.nonce;
        }

        void setNonce(String nonce) {
            this.nonce = nonce;
        }

        DigestQop getQop() {
            return this.qop;
        }

        void setQop(DigestQop qop) {
            this.qop = qop;
        }

        void setAlgorithm(DigestAlgorithm algorithm) throws NoSuchAlgorithmException {
            this.digest = algorithm.getMessageDigest();
        }

        MessageDigest getDigest() {
            return this.digest;
        }

        Map<DigestAuthorizationToken, String> getParsedHeader() {
            return this.parsedHeader;
        }

        void setParsedHeader(Map<DigestAuthorizationToken, String> parsedHeader) {
            this.parsedHeader = parsedHeader;
        }
    }
}

