/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.BufferCacheDefinition;
import org.wildfly.extension.undertow.ByteBufferPoolDefinition;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.UndertowSubsystemAdd;
import org.wildfly.extension.undertow.filters.FilterDefinitions;
import org.wildfly.extension.undertow.handlers.HandlerDefinitions;

class UndertowRootDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> UNDERTOW_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow", (boolean)false, UndertowService.class).build();
    static final RuntimeCapability<Void> HTTP_INVOKER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.http-invoker", (boolean)false, PathHandler.class).build();
    protected static final SimpleAttributeDefinition DEFAULT_SERVLET_CONTAINER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-servlet-container", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default"))).setCapabilityReference(UNDERTOW_CAPABILITY, "org.wildfly.undertow.servlet-container", new AttributeDefinition[0])).build();
    protected static final SimpleAttributeDefinition DEFAULT_SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-server", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default-server"))).setCapabilityReference(UNDERTOW_CAPABILITY, "org.wildfly.undertow.server", new AttributeDefinition[0])).build();
    protected static final SimpleAttributeDefinition DEFAULT_VIRTUAL_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-virtual-host", ModelType.STRING, true).setRestartAllServices()).setDefaultValue(new ModelNode("default-host"))).setCapabilityReference(UNDERTOW_CAPABILITY, "org.wildfly.undertow.host", new AttributeDefinition[]{DEFAULT_SERVER})).build();
    protected static final SimpleAttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("instance-id", ModelType.STRING, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode().set(new ValueExpression("${jboss.node.name}")))).build();
    protected static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("statistics-enabled", ModelType.BOOLEAN, true).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition DEFAULT_SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-security-domain", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("other"))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF)).setRestartAllServices()).build();
    static final ApplicationSecurityDomainDefinition APPLICATION_SECURITY_DOMAIN = ApplicationSecurityDomainDefinition.INSTANCE;
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DEFAULT_VIRTUAL_HOST, DEFAULT_SERVLET_CONTAINER, DEFAULT_SERVER, INSTANCE_ID, STATISTICS_ENABLED, DEFAULT_SECURITY_DOMAIN};
    static final PersistentResourceDefinition[] CHILDREN = new PersistentResourceDefinition[]{ByteBufferPoolDefinition.INSTANCE, BufferCacheDefinition.INSTANCE, ServerDefinition.INSTANCE, ServletContainerDefinition.INSTANCE, HandlerDefinitions.INSTANCE, FilterDefinitions.INSTANCE, APPLICATION_SECURITY_DOMAIN};
    public static final UndertowRootDefinition INSTANCE = new UndertowRootDefinition();

    private UndertowRootDefinition() {
        super(new SimpleResourceDefinition.Parameters(UndertowExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)UndertowExtension.getResolver(new String[0])).setAddHandler((OperationStepHandler)new UndertowSubsystemAdd(APPLICATION_SECURITY_DOMAIN.getKnownSecurityDomainPredicate())).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addCapabilities(new RuntimeCapability[]{UNDERTOW_CAPABILITY, HTTP_INVOKER_RUNTIME_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return Arrays.asList(CHILDREN);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            if (attr == STATISTICS_ENABLED) {
                resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new AbstractWriteAttributeHandler<Void>(new AttributeDefinition[]{STATISTICS_ENABLED}){

                    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                        UndertowService service;
                        ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.UNDERTOW);
                        if (controller != null && (service = (UndertowService)controller.getService()) != null) {
                            service.setStatisticsEnabled(resolvedValue.asBoolean());
                        }
                        return false;
                    }

                    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
                        UndertowService service;
                        ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.UNDERTOW);
                        if (controller != null && (service = (UndertowService)controller.getService()) != null) {
                            service.setStatisticsEnabled(valueToRestore.asBoolean());
                        }
                    }
                });
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }
}

