/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.security.AuthenticationManager;
import org.wildfly.extension.undertow.deployment.SecurityActions;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.security.manager.WildFlySecurityManager;

class LogoutSessionListener
implements HttpSessionListener {
    private final AuthenticationManager manager;

    LogoutSessionListener(AuthenticationManager manager) {
        this.manager = manager;
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(() -> {
                this.sessionDestroyedImpl(se);
                return null;
            });
        } else {
            this.sessionDestroyedImpl(se);
        }
    }

    private void sessionDestroyedImpl(HttpSessionEvent se) {
        Account sessionAccount;
        AuthenticatedSessionManager.AuthenticatedSession authenticatedSession;
        HttpSessionImpl impl;
        Session session;
        SecurityContext securityContext;
        ServletRequestContext src = ServletRequestContext.current();
        Account requestAccount = null;
        if (src != null && (securityContext = src.getExchange().getSecurityContext()) != null && (requestAccount = securityContext.getAuthenticatedAccount()) != null) {
            this.clearAccount(requestAccount);
        }
        if (se.getSession() instanceof HttpSessionImpl && (session = (impl = (HttpSessionImpl)se.getSession()).getSession()) != null && (authenticatedSession = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession")) != null && (sessionAccount = authenticatedSession.getAccount()) != null && !sessionAccount.equals(requestAccount)) {
            this.clearAccount(sessionAccount);
        }
    }

    private void clearAccount(Account account) {
        Principal principal;
        Principal principal2 = principal = account instanceof AccountImpl ? ((AccountImpl)account).getOriginalPrincipal() : account.getPrincipal();
        if (principal != null) {
            Subject subject = SecurityActions.getSubject();
            this.manager.logout(principal, subject);
        }
    }
}

