/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.filters.SimpleFilterDefinition;

public class RewriteFilterDefinition
extends SimpleFilterDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"rewrite");
    public static final AttributeDefinition TARGET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("target", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition REDIRECT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("redirect", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(TARGET, REDIRECT);

    RewriteFilterDefinition() {
        super(PATH_ELEMENT, RewriteFilterDefinition::createHandlerWrapper);
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static HandlerWrapper createHandlerWrapper(OperationContext context, ModelNode model) throws OperationFailedException {
        String target = TARGET.resolveModelAttribute(context, model).asString();
        boolean redirect = REDIRECT.resolveModelAttribute(context, model).asBoolean();
        return next -> redirect ? new RedirectHandler(target) : new SetAttributeHandler(next, ExchangeAttributes.relativePath(), ExchangeAttributes.parser((ClassLoader)RewriteFilterDefinition.class.getClassLoader()).parse(target));
    }
}

