/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.SessionCookieConfig;

public class ServletContainerService
implements Service<ServletContainerService> {
    private final boolean allowNonStandardWrappers;
    private final ServletStackTraces stackTraces;
    private final SessionCookieConfig sessionCookieConfig;
    private final JSPConfig jspConfig;
    private volatile ServletContainer servletContainer;
    @Deprecated
    private final Map<String, Integer> secureListeners = new ConcurrentHashMap<String, Integer>(1);
    private final InjectedValue<DirectBufferCache> bufferCacheInjectedValue = new InjectedValue();
    private final InjectedValue<SessionPersistenceManager> sessionPersistenceManagerInjectedValue = new InjectedValue();

    public ServletContainerService(boolean allowNonStandardWrappers, ServletStackTraces stackTraces, SessionCookieConfig sessionCookieConfig, JSPConfig jspConfig) {
        this.allowNonStandardWrappers = allowNonStandardWrappers;
        this.stackTraces = stackTraces;
        this.sessionCookieConfig = sessionCookieConfig;
        this.jspConfig = jspConfig;
    }

    public void start(StartContext context) throws StartException {
        this.servletContainer = ServletContainer.Factory.newInstance();
    }

    public void stop(StopContext context) {
    }

    public ServletContainerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public boolean isAllowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public JSPConfig getJspConfig() {
        return this.jspConfig;
    }

    public ServletStackTraces getStackTraces() {
        return this.stackTraces;
    }

    public Integer lookupSecurePort(String listenerName) {
        Integer response = null;
        response = this.secureListeners.get(listenerName);
        if (response == null) {
            while (response == null && !this.secureListeners.isEmpty()) {
                try {
                    response = this.secureListeners.values().iterator().next();
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            }
        }
        if (response == null) {
            throw new IllegalStateException("No secure listeners defined.");
        }
        return response;
    }

    public void registerSecurePort(String listenerName, Integer port) {
        this.secureListeners.put(listenerName, port);
    }

    public void unregisterSecurePort(String name) {
        this.secureListeners.remove(name);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    InjectedValue<DirectBufferCache> getBufferCacheInjectedValue() {
        return this.bufferCacheInjectedValue;
    }

    public DirectBufferCache getBufferCache() {
        return (DirectBufferCache)this.bufferCacheInjectedValue.getOptionalValue();
    }

    InjectedValue<SessionPersistenceManager> getSessionPersistenceManagerInjectedValue() {
        return this.sessionPersistenceManagerInjectedValue;
    }

    public SessionPersistenceManager getSessionPersistenceManager() {
        return (SessionPersistenceManager)this.sessionPersistenceManagerInjectedValue.getOptionalValue();
    }
}

