/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.predicate.DispatcherTypePredicate;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextAssociationHandler
implements HttpHandler {
    private final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap;
    private final String contextId;
    private final HttpHandler next;
    private final PrivilegedAction<String> setContextIdAction;

    public SecurityContextAssociationHandler(Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap, String contextId, HttpHandler next) {
        this.runAsIdentityMetaDataMap = runAsIdentityMetaDataMap;
        this.contextId = contextId;
        this.next = next;
        this.setContextIdAction = new SetContextIDAction(contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String previousContextID;
        block4: {
            SecurityContext sc = (SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT);
            previousContextID = null;
            RunAsIdentityMetaData identity = null;
            RunAs old = null;
            try {
                ServletChain servlet = ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet();
                identity = this.runAsIdentityMetaDataMap.get(servlet.getManagedServlet().getServletInfo().getName());
                RunAsIdentity runAsIdentity = null;
                if (identity != null) {
                    UndertowLogger.ROOT_LOGGER.tracef("%s, runAs: %s", servlet.getManagedServlet().getServletInfo().getName(), identity);
                    runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
                }
                old = SecurityActions.setRunAsIdentity(runAsIdentity, sc);
                previousContextID = this.setContextID(this.setContextIdAction);
                this.next.handleRequest(exchange);
                if (identity == null) break block4;
            }
            catch (Throwable throwable) {
                if (identity != null) {
                    SecurityActions.setRunAsIdentity(old, sc);
                }
                this.setContextID(new SetContextIDAction(previousContextID));
                throw throwable;
            }
            SecurityActions.setRunAsIdentity(old, sc);
        }
        this.setContextID(new SetContextIDAction(previousContextID));
    }

    private String setContextID(PrivilegedAction<String> action) {
        if (WildFlySecurityManager.isChecking()) {
            return (String)WildFlySecurityManager.doUnchecked(action);
        }
        return action.run();
    }

    public static HandlerWrapper wrapper(final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap, final String contextId) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new PredicateHandler(Predicates.or((Predicate[])new Predicate[]{DispatcherTypePredicate.REQUEST, DispatcherTypePredicate.ASYNC}), (HttpHandler)new SecurityContextAssociationHandler(runAsIdentityMetaDataMap, contextId, handler), handler);
            }
        };
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private final String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String currentContextID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return currentContextID;
        }
    }
}

