/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.xnio.OptionMap;

public class HttpListenerAdd
extends ListenerAdd {
    static final ServiceName REGISTRY_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"http", "listener", "registry"});

    HttpListenerAdd(ListenerResourceDefinition definition) {
        super(definition);
    }

    @Override
    ListenerService<? extends ListenerService> createService(String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions) throws OperationFailedException {
        boolean certificateForwarding = HttpListenerResourceDefinition.CERTIFICATE_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        boolean proxyAddressForwarding = HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        return new HttpListenerService(name, serverName, listenerOptions, certificateForwarding, proxyAddressForwarding);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, ServiceBuilder<? extends ListenerService> serviceBuilder, ModelNode model, ListenerService service) throws OperationFailedException {
        String redirectBindingRef = ListenerResourceDefinition.REDIRECT_SOCKET.resolveModelAttribute(context, model).asString();
        serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{redirectBindingRef}), SocketBinding.class, service.getRedirectSocket());
        serviceBuilder.addDependency(REGISTRY_SERVICE_NAME, ListenerRegistry.class, ((HttpListenerService)service).getHttpListenerRegistry());
    }
}

