/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.vfs.VirtualFile;
import org.xnio.FileAccess;
import org.xnio.IoUtils;

public class VirtualFileResource
implements Resource {
    private final VirtualFile file;
    private final String path;

    public VirtualFileResource(VirtualFile file, String path) {
        this.file = file;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Date getLastModified() {
        return new Date(this.file.getLastModified());
    }

    public String getLastModifiedString() {
        Date lastModified = this.getLastModified();
        if (lastModified == null) {
            return null;
        }
        return DateUtils.toDateString((Date)lastModified);
    }

    public ETag getETag() {
        return null;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public List<Resource> list() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (VirtualFile child : this.file.getChildren()) {
            resources.add(new VirtualFileResource(child, this.path));
        }
        return resources;
    }

    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    public void serve(final Sender sender, final HttpServerExchange exchange, final IoCallback callback) {
        class TransferTask
        extends 1BaseFileTask {
            TransferTask() {
                abstract class BaseFileTask
                implements Runnable {
                    protected volatile FileChannel fileChannel;
                    final /* synthetic */ HttpServerExchange val$exchange;
                    final /* synthetic */ IoCallback val$callback;
                    final /* synthetic */ Sender val$sender;

                    BaseFileTask() {
                        this.val$exchange = httpServerExchange;
                        this.val$callback = ioCallback;
                        this.val$sender = sender;
                    }

                    protected boolean openFile() {
                        try {
                            this.fileChannel = this.val$exchange.getConnection().getWorker().getXnio().openFile(VirtualFileResource.this.file.getPhysicalFile(), FileAccess.READ_ONLY);
                        }
                        catch (FileNotFoundException e) {
                            this.val$exchange.setResponseCode(404);
                            this.val$callback.onException(this.val$exchange, this.val$sender, (IOException)e);
                            return false;
                        }
                        catch (IOException e) {
                            this.val$exchange.setResponseCode(500);
                            this.val$callback.onException(this.val$exchange, this.val$sender, e);
                            return false;
                        }
                        return true;
                    }
                }
                super(VirtualFileResource.this, httpServerExchange, ioCallback, sender2);
            }

            @Override
            public void run() {
                if (!this.openFile()) {
                    return;
                }
                sender.transferFrom(this.fileChannel, new IoCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        try {
                            IoUtils.safeClose((Closeable)fileChannel);
                        }
                        finally {
                            callback.onComplete(exchange, sender);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        try {
                            IoUtils.safeClose((Closeable)fileChannel);
                        }
                        finally {
                            callback.onException(exchange, sender, exception);
                        }
                    }
                });
            }
        }
        TransferTask task = new TransferTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch((Runnable)task);
        } else {
            task.run();
        }
    }

    public Long getContentLength() {
        return this.file.getSize();
    }

    public String getCacheKey() {
        return this.file.toString();
    }

    public File getFile() {
        try {
            return this.file.getPhysicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getResourceManagerRoot() {
        return null;
    }

    public URL getUrl() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

