/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jacc;

import io.undertow.security.idm.Account;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.SimplePrincipal;

public class JACCAuthorizationManager
implements AuthorizationManager {
    public boolean isUserInRole(String roleName, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        WebRoleRefPermission permission = new WebRoleRefPermission(servletInfo.getName(), roleName);
        Map principalVersusRolesMap = deployment.getDeploymentInfo().getPrincipalVersusRolesMap();
        Principal[] principals = this.getPrincipals(account, principalVersusRolesMap);
        CodeSource codeSource = servletInfo.getServletClass().getProtectionDomain().getCodeSource();
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, null, null, principals);
        return protectionDomain.implies((Permission)permission);
    }

    public boolean canAccessResource(List<SingleConstraintMatch> constraints, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        WebResourcePermission permission = new WebResourcePermission(this.getCanonicalURI(request), request.getMethod());
        Map principalVersusRolesMap = deployment.getDeploymentInfo().getPrincipalVersusRolesMap();
        Principal[] principals = this.getPrincipals(account, principalVersusRolesMap);
        CodeSource codeSource = servletInfo.getServletClass().getProtectionDomain().getCodeSource();
        ProtectionDomain protectionDomain = new ProtectionDomain(codeSource, null, null, principals);
        return protectionDomain.implies((Permission)permission);
    }

    public TransportGuaranteeType transportGuarantee(TransportGuaranteeType currentConnGuarantee, TransportGuaranteeType configuredRequiredGuarantee, HttpServletRequest request) {
        ProtectionDomain domain = new ProtectionDomain(null, null, null, null);
        String[] httpMethod = new String[]{request.getMethod()};
        String canonicalURI = this.getCanonicalURI(request);
        switch (currentConnGuarantee) {
            case NONE: {
                WebUserDataPermission permission = new WebUserDataPermission(canonicalURI, httpMethod, null);
                if (domain.implies((Permission)permission)) {
                    return TransportGuaranteeType.NONE;
                }
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: 
            case CONFIDENTIAL: {
                WebUserDataPermission permission = new WebUserDataPermission(canonicalURI, httpMethod, TransportGuaranteeType.CONFIDENTIAL.name());
                if (domain.implies((Permission)permission)) {
                    return TransportGuaranteeType.CONFIDENTIAL;
                }
                permission = new WebUserDataPermission(canonicalURI, httpMethod, TransportGuaranteeType.INTEGRAL.name());
                if (domain.implies((Permission)permission)) {
                    return TransportGuaranteeType.INTEGRAL;
                }
                return TransportGuaranteeType.REJECTED;
            }
        }
        return TransportGuaranteeType.REJECTED;
    }

    private String getCanonicalURI(HttpServletRequest request) {
        String canonicalURI = request.getRequestURI().substring(request.getContextPath().length());
        if (canonicalURI == null || canonicalURI.equals("/")) {
            canonicalURI = "";
        }
        return canonicalURI;
    }

    private Principal[] getPrincipals(Account account, Map<String, Set<String>> principalVersusRolesMap) {
        if (account == null) {
            return null;
        }
        Set<String> mappedRoles = principalVersusRolesMap.get(account.getPrincipal().getName());
        HashSet<SimplePrincipal> roles = new HashSet<SimplePrincipal>();
        for (String role : account.getRoles()) {
            roles.add(new SimplePrincipal(role));
        }
        if (mappedRoles != null) {
            for (String role : mappedRoles) {
                roles.add(new SimplePrincipal(role));
            }
        }
        if (roles.isEmpty()) {
            return new Principal[]{account.getPrincipal()};
        }
        return roles.toArray(new Principal[roles.size()]);
    }
}

