/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.util.Headers;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowLogger;

class ConsoleRedirectService
implements Service<ConsoleRedirectService> {
    private static final String CONSOLE_PATH = "/console";
    private static final String NO_CONSOLE = "/noconsole.html";
    private static final String NO_REDIRECT = "/noredirect.html";
    private final InjectedValue<HttpManagement> httpManagementInjector = new InjectedValue();
    private final InjectedValue<Host> hostInjector = new InjectedValue();

    ConsoleRedirectService() {
    }

    public void start(StartContext startContext) throws StartException {
        Host host = (Host)this.hostInjector.getValue();
        UndertowLogger.ROOT_LOGGER.debugf("Starting console redirect for %s", host.getName());
        HttpManagement httpManagement = (HttpManagement)this.httpManagementInjector.getOptionalValue();
        if (httpManagement != null) {
            if (httpManagement.hasConsole()) {
                host.registerHandler(CONSOLE_PATH, new ConsoleRedirectHandler(httpManagement));
            } else {
                host.registerHandler(CONSOLE_PATH, (HttpHandler)new RedirectHandler(NO_CONSOLE));
            }
        } else {
            host.registerHandler(CONSOLE_PATH, (HttpHandler)new RedirectHandler(NO_CONSOLE));
        }
    }

    public void stop(StopContext stopContext) {
        Host host = (Host)this.hostInjector.getValue();
        UndertowLogger.ROOT_LOGGER.debugf("Stopping console redirect for %s", host.getName());
        host.unregisterHandler(CONSOLE_PATH);
    }

    public ConsoleRedirectService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected InjectedValue<HttpManagement> getHttpManagementInjector() {
        return this.httpManagementInjector;
    }

    protected InjectedValue<Host> getHostInjector() {
        return this.hostInjector;
    }

    private static class ConsoleRedirectHandler
    implements HttpHandler {
        private static final int DEFAULT_PORT = 80;
        private static final String HTTP = "http";
        private static final String HTTPS = "https";
        private static final int SECURE_DEFAULT_PORT = 443;
        private final int port;
        private final int securePort;
        private final NetworkInterfaceBinding networkInterfaceBinding;
        private final NetworkInterfaceBinding secureNetworkInterfaceBinding;

        ConsoleRedirectHandler(HttpManagement httpManagement) {
            this.port = httpManagement.getHttpPort();
            this.securePort = httpManagement.getHttpsPort();
            this.networkInterfaceBinding = httpManagement.getHttpNetworkInterfaceBinding();
            this.secureNetworkInterfaceBinding = httpManagement.getHttpsNetworkInterfaceBinding();
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            String location = ConsoleRedirectService.NO_REDIRECT;
            if (this.port > -1 || this.securePort > -1) {
                try {
                    location = this.securePort > -1 ? this.assembleURI(HTTPS, this.secureNetworkInterfaceBinding, this.securePort, 443, exchange) : this.assembleURI(HTTP, this.networkInterfaceBinding, this.port, 80, exchange);
                }
                catch (URISyntaxException e) {
                    UndertowLogger.ROOT_LOGGER.invalidRedirectURI(e);
                }
            }
            RedirectHandler redirectHandler = new RedirectHandler(location);
            redirectHandler.handleRequest(exchange);
        }

        private String assembleURI(String scheme, NetworkInterfaceBinding interfaceBinding, int port, int defaultPort, HttpServerExchange exchange) throws URISyntaxException {
            int p = port != defaultPort ? port : -1;
            String hostname = this.getRedirectHostname(interfaceBinding.getAddress(), exchange);
            if (hostname == null) {
                return ConsoleRedirectService.NO_REDIRECT;
            }
            return new URI(scheme, null, hostname, p, ConsoleRedirectService.CONSOLE_PATH, null, null).toString();
        }

        private String getRedirectHostname(InetAddress managementAddress, HttpServerExchange exchange) {
            String hostname;
            InetAddress destinationAddress = exchange.getDestinationAddress().getAddress();
            if ((managementAddress.equals(destinationAddress) || managementAddress.isAnyLocalAddress()) && (hostname = exchange.getRequestHeaders().getFirst(Headers.HOST)) != null) {
                int portPos = hostname.indexOf(58);
                if (portPos > 0) {
                    hostname = hostname.substring(0, portPos);
                }
                return hostname;
            }
            if (managementAddress.isLoopbackAddress() && destinationAddress.isLoopbackAddress()) {
                hostname = managementAddress.getHostAddress();
                int zonePos = hostname.indexOf(37);
                if (zonePos > 0) {
                    hostname = hostname.substring(0, zonePos);
                }
                return hostname;
            }
            return null;
        }
    }
}

