/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.AbstractPersistentSessionManager;
import org.wildfly.extension.undertow.UndertowMessages;
import org.xnio.IoUtils;

public class DiskBasedModularPersistentSessionManager
extends AbstractPersistentSessionManager {
    private final String path;
    private final String pathRelativeTo;
    private File baseDir;
    private PathManager.Callback.Handle callbackHandle;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();

    public DiskBasedModularPersistentSessionManager(String path, String pathRelativeTo) {
        this.path = path;
        this.pathRelativeTo = pathRelativeTo;
    }

    @Override
    public synchronized void stop(StopContext stopContext) {
        super.stop(stopContext);
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    @Override
    public synchronized void start(StartContext startContext) throws StartException {
        super.start(startContext);
        if (this.pathRelativeTo != null) {
            this.callbackHandle = ((PathManager)this.pathManager.getValue()).registerCallback(this.pathRelativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        }
        this.baseDir = new File(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.path, this.pathRelativeTo));
        if (!this.baseDir.exists() && !this.baseDir.mkdirs()) {
            throw UndertowMessages.MESSAGES.failedToCreatePersistentSessionDir(this.baseDir);
        }
        if (!this.baseDir.isDirectory()) {
            throw UndertowMessages.MESSAGES.invalidPersistentSessionDir(this.baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void persistSerializedSessions(String deploymentName, Map<String, AbstractPersistentSessionManager.SessionEntry> serializedData) throws IOException {
        File file = new File(this.baseDir, deploymentName);
        FileOutputStream out = new FileOutputStream(file, false);
        try (Marshaller marshaller = this.createMarshaller();){
            marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)out));
            marshaller.writeObject(serializedData);
            marshaller.finish();
        }
        finally {
            IoUtils.safeClose((Closeable)out);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Map<String, AbstractPersistentSessionManager.SessionEntry> loadSerializedSessions(String deploymentName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }
}

