/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.common;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Map;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.web.common.AbstractWebInjectionContainer;
import org.jboss.as.web.common.ConcurrentReferenceHashMap;

public class CachingWebInjectionContainer
extends AbstractWebInjectionContainer {
    private final Map<Object, ManagedReference> references = new ConcurrentReferenceHashMap<Object, ManagedReference>(256, 0.75f, Runtime.getRuntime().availableProcessors(), ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));

    public CachingWebInjectionContainer(ClassLoader loader, ComponentRegistry componentRegistry) {
        super(loader, componentRegistry);
    }

    @Override
    public void destroyInstance(Object instance) {
        ManagedReference reference = this.references.remove(instance);
        if (reference != null) {
            reference.release();
        }
    }

    @Override
    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        ManagedReferenceFactory factory = this.getComponentRegistry().createInstanceFactory(clazz);
        ManagedReference reference = factory.getReference();
        if (reference != null) {
            this.references.put(reference.getInstance(), reference);
            return reference.getInstance();
        }
        return clazz.newInstance();
    }

    @Override
    public void newInstance(Object instance) {
        ManagedReference reference = this.getComponentRegistry().createInstance(instance);
        if (reference != null) {
            this.references.put(instance, reference);
        }
    }
}

