/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.config;

import java.io.File;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.webservices.config.ServerHostInfo;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.msc.value.InjectedValue;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.management.AbstractServerConfigMBean;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowService;

public final class ServerConfigImpl
extends AbstractServerConfig
implements AbstractServerConfigMBean {
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<UndertowService> injectedUndertowService = new InjectedValue();
    private final AtomicInteger wsDeploymentCount = new AtomicInteger(0);
    private final DMRSynchCheckHandler webServiceHostUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler webServicePortUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler webServiceSecurePortUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler webServiceUriSchemeUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler modifySOAPAddressUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler webServicePathRewriteRuleUCH = new DMRSynchCheckHandler();

    private ServerConfigImpl() {
    }

    public void create() throws Exception {
        super.create();
        this.wsDeploymentCount.set(0);
        this.webServiceHostUCH.reset();
        this.webServicePortUCH.reset();
        this.webServiceSecurePortUCH.reset();
        this.modifySOAPAddressUCH.reset();
        this.webServicePathRewriteRuleUCH.reset();
    }

    public void incrementWSDeploymentCount() {
        this.wsDeploymentCount.incrementAndGet();
    }

    public void decrementWSDeploymentCount() {
        this.wsDeploymentCount.decrementAndGet();
    }

    protected boolean isModifiable() {
        return this.wsDeploymentCount.get() == 0;
    }

    public void setWebServiceHost(String host, boolean forceUpdate) throws UnknownHostException {
        this.setWebServiceHost(host, forceUpdate ? null : this.webServiceHostUCH);
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        this.setWebServiceHost(host, this.webServiceHostUCH);
    }

    public void setWebServicePathRewriteRule(String path, boolean forceUpdate) {
        this.setWebServicePathRewriteRule(path, forceUpdate ? null : this.webServicePathRewriteRuleUCH);
    }

    public void setWebServicePathRewriteRule(String path) {
        this.setWebServicePathRewriteRule(path, this.webServicePathRewriteRuleUCH);
    }

    public void setWebServicePort(int port, boolean forceUpdate) {
        this.setWebServicePort(port, forceUpdate ? null : this.webServicePortUCH);
    }

    public void setWebServicePort(int port) {
        this.setWebServicePort(port, this.webServicePortUCH);
    }

    public void setWebServiceSecurePort(int port, boolean forceUpdate) {
        this.setWebServiceSecurePort(port, forceUpdate ? null : this.webServiceSecurePortUCH);
    }

    public void setWebServiceUriScheme(String scheme, boolean forceUpdate) {
        this.setWebServiceUriScheme(scheme, forceUpdate ? null : this.webServiceUriSchemeUCH);
    }

    public void setWebServiceSecurePort(int port) {
        this.setWebServiceSecurePort(port, this.webServiceSecurePortUCH);
    }

    public void setModifySOAPAddress(boolean flag, boolean forceUpdate) {
        this.setModifySOAPAddress(flag, forceUpdate ? null : this.modifySOAPAddressUCH);
    }

    public void setModifySOAPAddress(boolean flag) {
        this.setModifySOAPAddress(flag, this.modifySOAPAddressUCH);
    }

    public File getServerTempDir() {
        return this.getServerEnvironment().getServerTempDir();
    }

    public File getHomeDir() {
        return this.getServerEnvironment().getHomeDir();
    }

    public File getServerDataDir() {
        return this.getServerEnvironment().getServerDataDir();
    }

    public MBeanServer getMbeanServer() {
        return (MBeanServer)this.injectedMBeanServer.getValue();
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        throw new UnsupportedOperationException();
    }

    public InjectedValue<MBeanServer> getMBeanServerInjector() {
        return this.injectedMBeanServer;
    }

    public InjectedValue<ServerEnvironment> getServerEnvironmentInjector() {
        return this.injectedServerEnvironment;
    }

    public InjectedValue<UndertowService> getUndertowServiceInjector() {
        return this.injectedUndertowService;
    }

    private ServerEnvironment getServerEnvironment() {
        return (ServerEnvironment)this.injectedServerEnvironment.getValue();
    }

    private UndertowService getUndertowService() {
        return (UndertowService)this.injectedUndertowService.getValue();
    }

    public static ServerConfigImpl newInstance() {
        return new ServerConfigImpl();
    }

    public void setClientConfigWrapper(ClientConfig config, boolean reload) {
        this.clientConfigStore.setWrapperConfig((AbstractCommonConfig)config, reload);
    }

    public Integer getVirtualHostPort(String hostname, boolean securePort) {
        ServerHostInfo hostInfo = new ServerHostInfo(hostname);
        Host undertowHost = this.getUndertowHost(hostInfo);
        if (undertowHost != null && !undertowHost.getServer().getListeners().isEmpty()) {
            for (ListenerService listener : undertowHost.getServer().getListeners()) {
                if (listener.isSecure() != securePort) continue;
                return ((SocketBinding)listener.getBinding().getValue()).getAbsolutePort();
            }
        }
        return null;
    }

    public String getHostAlias(String hostname) {
        ServerHostInfo hostInfo = new ServerHostInfo(hostname);
        Host undertowHost = this.getUndertowHost(hostInfo);
        if (undertowHost != null && !undertowHost.getAllAliases().isEmpty()) {
            for (String alias : undertowHost.getAllAliases()) {
                if (undertowHost.getAllAliases().size() != 1 && alias.equals(undertowHost.getName())) continue;
                return alias;
            }
        }
        return null;
    }

    private Host getUndertowHost(ServerHostInfo info) {
        UndertowService us = this.getUndertowService();
        if (us != null) {
            for (Server server : this.getUndertowService().getServers()) {
                if (info.getServerInstanceName() != null && !server.getName().equals(info.getServerInstanceName())) continue;
                for (Host undertowHost : server.getHosts()) {
                    if (!undertowHost.getName().equals(info.getHost())) continue;
                    return undertowHost;
                }
            }
        }
        return null;
    }

    private class DMRSynchCheckHandler
    implements AbstractServerConfig.UpdateCallbackHandler {
        private volatile boolean dmrSynched = true;

        private DMRSynchCheckHandler() {
        }

        public void onBeforeUpdate() {
            if (!this.dmrSynched) {
                throw WSLogger.ROOT_LOGGER.couldNotUpdateServerConfigBecauseOfReloadRequired();
            }
            if (!ServerConfigImpl.this.isModifiable()) {
                this.dmrSynched = false;
                throw WSLogger.ROOT_LOGGER.couldNotUpdateServerConfigBecauseOfExistingWSDeployment();
            }
        }

        public void reset() {
            this.dmrSynched = true;
        }
    }
}

