/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Vector;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.api.monitoring.RecordProcessorFactory;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class EndpointRecordProcessorDeploymentAspect
extends AbstractDeploymentAspect {
    private List<RecordProcessor> processors = new LinkedList<RecordProcessor>();

    public EndpointRecordProcessorDeploymentAspect() {
        ServiceLoader<RecordProcessorFactory> loader = ServiceLoader.load(RecordProcessorFactory.class);
        for (RecordProcessorFactory factory : loader) {
            this.processors.addAll(factory.newRecordProcessors());
        }
    }

    public void start(Deployment dep) {
        int size = this.processors.size();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Vector<RecordProcessor> processorList = new Vector<RecordProcessor>(size);
            for (RecordProcessor pr : this.processors) {
                try {
                    RecordProcessor clone = (RecordProcessor)pr.clone();
                    processorList.add(clone);
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ep.setRecordProcessors(processorList);
        }
    }

    public void stop(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ep.setRecordProcessors(Collections.emptyList());
        }
    }
}

