/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class WSDependenciesProcessor
implements DeploymentUnitProcessor {
    public static final String JBOSSWS_API = "org.jboss.ws.api";
    public static final String JBOSSWS_SPI = "org.jboss.ws.spi";
    public static final String[] JAVAEE_APIS = new String[]{"jakarta.xml.ws.api", "jakarta.xml.soap.api"};
    public static final String XERCES_IMPL = "org.apache.xerces";
    private final boolean addJBossWSDependencies;

    public WSDependenciesProcessor(boolean addJBossWSDependencies) {
        this.addJBossWSDependencies = addJBossWSDependencies;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (this.addJBossWSDependencies) {
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, JBOSSWS_API, false, true, true, false));
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, JBOSSWS_SPI, false, true, true, false));
        }
        for (String api : JAVAEE_APIS) {
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, api, false, false, true, false));
        }
        if (Endpoint.class.getPackage().getImplementationVersion().startsWith("3")) {
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, XERCES_IMPL, true, false, true, false));
        }
    }
}

