/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import org.jboss.as.naming.ImmediateManagedReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefFactoryFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WebServiceManagedReferenceFactory
implements ManagedReferenceFactory {
    private final UnifiedServiceRefMetaData serviceRef;
    private final ClassLoader classLoader;

    public WebServiceManagedReferenceFactory(UnifiedServiceRefMetaData serviceRef, ClassLoader classLoader) {
        this.serviceRef = serviceRef;
        this.classLoader = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedReference getReference() {
        ClassLoader oldCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ServiceRefFactory serviceRefFactory = this.getServiceRefFactory();
            ImmediateManagedReference immediateManagedReference = new ImmediateManagedReference(serviceRefFactory.newServiceRef(this.serviceRef));
            return immediateManagedReference;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCL);
        }
    }

    private ServiceRefFactory getServiceRefFactory() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        return ((ServiceRefFactoryFactory)spiProvider.getSPI(ServiceRefFactoryFactory.class)).newServiceRefFactory();
    }
}

