/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.dmr.WSDeploymentActivator;
import org.jboss.as.webservices.dmr.WSExtension;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.util.ModuleClassLoaderProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class WSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final WSSubsystemAdd INSTANCE = new WSSubsystemAdd();

    WSSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attr : Attributes.SUBSYSTEM_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServerConfigImpl serverConfig;
        WSLogger.ROOT_LOGGER.activatingWebservicesExtension();
        ModuleClassLoaderProvider.register();
        final boolean appclient = context.getProcessType() == ProcessType.APPLICATION_CLIENT;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                WSDeploymentActivator.activate(processorTarget, appclient);
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget serviceTarget = context.getServiceTarget();
        if (appclient && model.hasDefined("wsdl-host")) {
            serverConfig = WSSubsystemAdd.createServerConfig(model, true, context);
            newControllers.add(ServerConfigService.install(serviceTarget, serverConfig, (ServiceListener<Object>)verificationHandler, WSSubsystemAdd.getServerConfigDependencies(context)));
        }
        if (!appclient) {
            serverConfig = WSSubsystemAdd.createServerConfig(model, false, context);
            newControllers.add(ServerConfigService.install(serviceTarget, serverConfig, (ServiceListener<Object>)verificationHandler, WSSubsystemAdd.getServerConfigDependencies(context)));
        }
    }

    private static ServerConfigImpl createServerConfig(ModelNode configuration, boolean appclient, OperationContext context) throws OperationFailedException {
        ServerConfigImpl config = ServerConfigImpl.newInstance();
        try {
            ModelNode wsdlHost = Attributes.WSDL_HOST.resolveModelAttribute(context, configuration);
            config.setWebServiceHost(wsdlHost.isDefined() ? wsdlHost.asString() : null);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (!appclient) {
            config.setModifySOAPAddress(Attributes.MODIFY_WSDL_ADDRESS.resolveModelAttribute(context, configuration).asBoolean());
        }
        if (configuration.hasDefined("wsdl-port")) {
            config.setWebServicePort(Attributes.WSDL_PORT.resolveModelAttribute(context, configuration).asInt());
        }
        if (configuration.hasDefined("wsdl-secure-port")) {
            config.setWebServiceSecurePort(Attributes.WSDL_SECURE_PORT.resolveModelAttribute(context, configuration).asInt());
        }
        return config;
    }

    private static List<ServiceName> getServerConfigDependencies(OperationContext context) {
        ArrayList<ServiceName> serviceNames = new ArrayList<ServiceName>();
        Resource subsystemResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{WSExtension.SUBSYSTEM_PATH}));
        WSSubsystemAdd.readConfigServiceNames(serviceNames, subsystemResource, "client-config");
        WSSubsystemAdd.readConfigServiceNames(serviceNames, subsystemResource, "endpoint-config");
        return serviceNames;
    }

    private static void readConfigServiceNames(List<ServiceName> serviceNames, Resource subsystemResource, String configType) {
        for (Resource.ResourceEntry re : subsystemResource.getChildren(configType)) {
            ServiceName configServiceName = "client-config".equals(configType) ? PackageUtils.getClientConfigServiceName(re.getName()) : PackageUtils.getEndpointConfigServiceName(re.getName());
            serviceNames.add(configServiceName);
            WSSubsystemAdd.readHandlerChainServiceNames(serviceNames, (Resource)re, "pre-handler-chain", configServiceName);
            WSSubsystemAdd.readHandlerChainServiceNames(serviceNames, (Resource)re, "post-handler-chain", configServiceName);
            for (String propertyName : re.getChildrenNames("property")) {
                serviceNames.add(PackageUtils.getPropertyServiceName(configServiceName, propertyName));
            }
        }
    }

    private static void readHandlerChainServiceNames(List<ServiceName> serviceNames, Resource configResource, String chainType, ServiceName configServiceName) {
        for (Resource.ResourceEntry re : configResource.getChildren(chainType)) {
            ServiceName handlerChainServiceName = PackageUtils.getHandlerChainServiceName(configServiceName, re.getName());
            serviceNames.add(handlerChainServiceName);
            for (String handlerName : re.getChildrenNames("handler")) {
                serviceNames.add(PackageUtils.getHandlerServiceName(handlerChainServiceName, handlerName));
            }
        }
    }
}

