/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.HashMap;
import java.util.HashSet;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.deployers.AbstractIntegrationProcessorJAXWS;
import org.jboss.as.webservices.deployers.WebServiceAnnotationInfo;
import org.jboss.as.webservices.deployers.WebServiceProviderAnnotationInfo;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.jandex.ClassInfo;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

public class WSIntegrationProcessorJAXWS_POJO
extends AbstractIntegrationProcessorJAXWS {
    @Override
    protected void processAnnotation(DeploymentUnit unit, EEModuleDescription moduleDescription) throws DeploymentUnitProcessingException {
        HashMap<String, EEModuleClassDescription> classDescriptionMap = new HashMap<String, EEModuleClassDescription>();
        CompositeIndex index = (CompositeIndex)unit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (EEModuleClassDescription classDescritpion : moduleDescription.getClassDescriptions()) {
            if (!ASHelper.isJaxwsEndpoint(classDescritpion, index) || this.exclude(unit, classDescritpion)) continue;
            classDescriptionMap.put(classDescritpion.getClassName(), classDescritpion);
        }
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        JAXWSDeployment jaxwsDeployment = ASHelper.getJaxwsDeployment(unit);
        if (jbossWebMD != null) {
            HashSet<String> matchedEps = new HashSet<String>();
            for (ServletMetaData servletMD : WebMetaDataHelper.getServlets(jbossWebMD)) {
                String endpointClassName = ASHelper.getEndpointClassName(servletMD);
                String endpointName = ASHelper.getEndpointName(servletMD);
                if (classDescriptionMap.containsKey(endpointClassName) || matchedEps.contains(endpointClassName)) {
                    ComponentDescription pojoComponent = WSIntegrationProcessorJAXWS_POJO.createComponentDescription(unit, endpointName, endpointClassName, endpointName);
                    ServiceName pojoViewName = WSIntegrationProcessorJAXWS_POJO.registerView(pojoComponent, endpointClassName);
                    String urlPattern = WSIntegrationProcessorJAXWS_POJO.getUrlPattern(endpointName, unit);
                    jaxwsDeployment.addEndpoint(new POJOEndpoint(endpointName, endpointClassName, pojoViewName, urlPattern));
                    classDescriptionMap.remove(endpointClassName);
                    matchedEps.add(endpointClassName);
                    continue;
                }
                if (unit.getParent() == null || !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit.getParent())) continue;
                EEModuleDescription eeModuleDescription = (EEModuleDescription)unit.getParent().getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                CompositeIndex parentIndex = (CompositeIndex)unit.getParent().getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
                for (EEModuleClassDescription classDescription : eeModuleDescription.getClassDescriptions()) {
                    if (!classDescription.getClassName().equals(endpointClassName) || !ASHelper.isJaxwsEndpoint(classDescription, parentIndex)) continue;
                    ComponentDescription pojoComponent = WSIntegrationProcessorJAXWS_POJO.createComponentDescription(unit, endpointName, endpointClassName, endpointName);
                    ServiceName pojoViewName = WSIntegrationProcessorJAXWS_POJO.registerView(pojoComponent, endpointClassName);
                    String urlPattern = WSIntegrationProcessorJAXWS_POJO.getUrlPattern(endpointName, unit);
                    jaxwsDeployment.addEndpoint(new POJOEndpoint(endpointName, endpointClassName, pojoViewName, urlPattern));
                }
            }
        }
        for (EEModuleClassDescription classDescription : classDescriptionMap.values()) {
            ClassAnnotationInformation annotationProviderInfo;
            ClassInfo classInfo = null;
            String serviceName = null;
            ClassAnnotationInformation annotationInfo = classDescription.getAnnotationInformation(WebService.class);
            if (annotationInfo != null) {
                WebServiceAnnotationInfo wsInfo = (WebServiceAnnotationInfo)annotationInfo.getClassLevelAnnotations().get(0);
                serviceName = wsInfo.getServiceName();
                classInfo = (ClassInfo)wsInfo.getTarget();
            }
            if ((annotationProviderInfo = classDescription.getAnnotationInformation(WebServiceProvider.class)) != null) {
                WebServiceProviderAnnotationInfo wsInfo = (WebServiceProviderAnnotationInfo)annotationProviderInfo.getClassLevelAnnotations().get(0);
                serviceName = wsInfo.getServiceName();
                classInfo = (ClassInfo)wsInfo.getTarget();
            }
            if (classInfo == null) continue;
            String endpointClassName = classDescription.getClassName();
            ComponentDescription pojoComponent = WSIntegrationProcessorJAXWS_POJO.createComponentDescription(unit, endpointClassName, endpointClassName, endpointClassName);
            ServiceName pojoViewName = WSIntegrationProcessorJAXWS_POJO.registerView(pojoComponent, endpointClassName);
            String urlPattern = WSIntegrationProcessorJAXWS_POJO.getUrlPattern(classInfo, serviceName);
            jaxwsDeployment.addEndpoint(new POJOEndpoint(endpointClassName, pojoViewName, urlPattern));
        }
    }

    private boolean exclude(DeploymentUnit unit, EEModuleClassDescription classDescription) {
        ClassInfo classInfo = null;
        ClassAnnotationInformation annotationInfo = classDescription.getAnnotationInformation(WebService.class);
        if (annotationInfo != null) {
            classInfo = (ClassInfo)((WebServiceAnnotationInfo)annotationInfo.getClassLevelAnnotations().get(0)).getTarget();
        } else {
            ClassAnnotationInformation providreInfo = classDescription.getAnnotationInformation(WebServiceProvider.class);
            classInfo = (ClassInfo)((WebServiceProviderAnnotationInfo)providreInfo.getClassLevelAnnotations().get(0)).getTarget();
        }
        return WSIntegrationProcessorJAXWS_POJO.isEjb3(classInfo) || WSIntegrationProcessorJAXWS_POJO.isJmsEndpoint(unit, classInfo);
    }

    private static String getUrlPattern(ClassInfo clazz, String serviceName) {
        return "/" + (!serviceName.equals("") ? serviceName : clazz.name().local());
    }

    private static String getUrlPattern(String servletName, DeploymentUnit unit) {
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        for (ServletMappingMetaData servletMappingMD : jbossWebMD.getServletMappings()) {
            if (!servletName.equals(servletMappingMD.getServletName())) continue;
            return (String)servletMappingMD.getUrlPatterns().get(0);
        }
        throw new IllegalStateException();
    }

    private static boolean isJmsEndpoint(DeploymentUnit unit, ClassInfo classInfo) {
        String endpointClassName = classInfo.name().toString();
        JMSEndpointsMetaData jmsEndpointsMD = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
        for (JMSEndpointMetaData endpoint : jmsEndpointsMD.getEndpointsMetaData()) {
            if (!endpointClassName.equals(endpoint.getImplementor())) continue;
            return true;
        }
        return false;
    }
}

