/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.service.HandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

final class HandlerAdd
extends AbstractAddStepHandler {
    static final HandlerAdd INSTANCE = new HandlerAdd();

    private HandlerAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        super.rollbackRuntime(context, operation, model, controllers);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        if (context.isBooting()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 3);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainId = address.getElement(address.size() - 2).getValue();
            String handlerName = address.getElement(address.size() - 1).getValue();
            String handlerClass = operation.require("class").asString();
            HandlerService service = new HandlerService(handlerName, handlerClass);
            ServiceTarget target = context.getServiceTarget();
            ServiceName configServiceName = PackageUtils.getConfigServiceName(configType, configName);
            ServiceRegistry registry = context.getServiceRegistry(false);
            if (registry.getService(configServiceName) == null) {
                throw WSMessages.MESSAGES.missingConfig(configName);
            }
            ServiceName handlerChainServiceName = PackageUtils.getHandlerChainServiceName(configServiceName, handlerChainId);
            if (registry.getService(handlerChainServiceName) == null) {
                String handlerChainType = address.getElement(address.size() - 2).getKey();
                throw WSMessages.MESSAGES.missingHandlerChain(configName, handlerChainType, handlerChainId);
            }
            ServiceName handlerServiceName = PackageUtils.getHandlerServiceName(handlerChainServiceName, handlerName);
            ServiceBuilder handlerServiceBuilder = target.addService(handlerServiceName, (Service)service);
            handlerServiceBuilder.addDependency(handlerChainServiceName, UnifiedHandlerChainMetaData.class, service.getHandlerChain());
            ServiceController controller = handlerServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            if (newControllers != null) {
                newControllers.add(controller);
            }
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.CLASS.validateAndSet(operation, model);
    }
}

